/*
 * Decompiled with CFR 0.152.
 */
package com.mzlion.core.http;

import com.mzlion.core.lang.StringUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class UrlUtils {
    public static String encode(String url) {
        return UrlUtils.encode(url, StandardCharsets.UTF_8);
    }

    public static String encode(String url, Charset charset) {
        if (StringUtils.isEmpty(url)) {
            return "";
        }
        if (charset == null) {
            charset = StandardCharsets.UTF_8;
        }
        try {
            return URLEncoder.encode(url, charset.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String decode(String url) {
        return UrlUtils.decode(url, StandardCharsets.UTF_8);
    }

    public static String decode(String url, Charset charset) {
        if (StringUtils.isEmpty(url)) {
            return "";
        }
        if (charset == null) {
            charset = StandardCharsets.UTF_8;
        }
        try {
            return URLDecoder.decode(url, charset.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

