/*
 * Decompiled with CFR 0.152.
 */
package com.mzlion.core.io;

import com.mzlion.core.lang.StringUtils;
import java.io.File;

public class FilenameUtils {
    public static final String LINUX_SEPARATOR = "/";
    public static final String WINDOWS_SEPARATOR = "\\";
    public static final String EXTENSION_SEPARATOR = ".";

    public static String getFilename(String path) {
        if (!StringUtils.hasLength(path)) {
            return null;
        }
        int separatorIndex = path.lastIndexOf(WINDOWS_SEPARATOR);
        if (separatorIndex == -1) {
            separatorIndex = path.lastIndexOf(LINUX_SEPARATOR);
        }
        return separatorIndex != -1 ? path.substring(separatorIndex + 1) : path;
    }

    public static String getFileExt(String path) {
        String filename = FilenameUtils.getFilename(path);
        if (StringUtils.isEmpty(filename)) {
            return null;
        }
        int extIndex = filename.lastIndexOf(EXTENSION_SEPARATOR);
        if (extIndex == -1) {
            return null;
        }
        return filename.substring(extIndex + 1);
    }

    public static String getFileExt(File file) {
        if (file == null) {
            return null;
        }
        return FilenameUtils.getFileExt(file.getName());
    }

    public static String stripFilenameSuffix(String path) {
        String filename = FilenameUtils.getFilename(path);
        if (filename == null) {
            return null;
        }
        int extIndex = filename.lastIndexOf(EXTENSION_SEPARATOR);
        if (extIndex == -1) {
            return path;
        }
        return filename.substring(0, extIndex);
    }

    public static String applyRelativePath(String path, String relativePath) {
        if (!StringUtils.hasText(path) || !StringUtils.hasText(relativePath)) {
            return null;
        }
        int separatorIndex = path.lastIndexOf(LINUX_SEPARATOR);
        if (separatorIndex != -1) {
            StringBuilder sb = new StringBuilder();
            sb.append(path.substring(0, separatorIndex));
            if (!relativePath.startsWith(LINUX_SEPARATOR)) {
                sb.append(LINUX_SEPARATOR);
            }
            return sb.append(relativePath).toString();
        }
        return relativePath;
    }
}

