/*
 * Decompiled with CFR 0.152.
 */
package com.mzlion.core.io;

import com.mzlion.core.lang.StringUtils;
import com.mzlion.core.utils.ClassLoaderUtils;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceUtils {
    private static Logger logger = LoggerFactory.getLogger(ResourceUtils.class);
    public static final String CLASSPATH_URL_PREFIX = "classpath:";
    public static final String FILE_URL_PREFIX = "file:";
    public static final String JAR_URL_PREFIX = "jar:";

    public static File getFile(String resourceLocation) {
        if (StringUtils.isEmpty(resourceLocation)) {
            logger.error("ResourceLocation must not be null.");
            return null;
        }
        if (resourceLocation.startsWith(CLASSPATH_URL_PREFIX)) {
            String realPath = resourceLocation.substring(CLASSPATH_URL_PREFIX.length());
            if (StringUtils.isEmpty(realPath)) {
                logger.error("The classpath has not a real path.");
                return null;
            }
            ClassLoader classLoader = ClassLoaderUtils.getDefaultClassLoader();
            URL url = classLoader.getResource(realPath);
            if (url == null) {
                url = ClassLoader.getSystemResource(realPath);
            }
            if (url == null) {
                logger.error("class path resource [" + realPath + "] cannot be resolved to absolute file path because it does not exist/");
                return null;
            }
            return ResourceUtils.getFile(url);
        }
        try {
            return ResourceUtils.getFile(new URL(resourceLocation));
        }
        catch (MalformedURLException e) {
            return new File(resourceLocation);
        }
    }

    private static File getFile(URL resourceUrl) {
        if (resourceUrl == null) {
            logger.error("URL must not be null.");
            return null;
        }
        try {
            return new File(ResourceUtils.toURI(resourceUrl).getSchemeSpecificPart());
        }
        catch (URISyntaxException e) {
            return new File(resourceUrl.getFile());
        }
    }

    public static URI toURI(URL url) throws URISyntaxException {
        return ResourceUtils.toURI(url.toString());
    }

    public static URI toURI(String location) throws URISyntaxException {
        return new URI(StringUtils.replace(location, " ", "%20"));
    }
}

