/*
 * Decompiled with CFR 0.152.
 */
package com.mzlion.core.json.gson;

import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.mzlion.core.json.TypeRef;
import com.mzlion.core.json.gson.PropertyNameExclusionStrategy;
import com.mzlion.core.json.gson.UnicodeStringWriter;
import com.mzlion.core.lang.ArrayUtils;
import com.mzlion.core.lang.StringUtils;
import java.lang.reflect.Type;
import java.util.Map;

public final class JsonUtil {
    private static Gson gson = new GsonBuilder().create();

    private JsonUtil() {
        throw new UnsupportedOperationException();
    }

    public static <T> String toJson(T value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        UnicodeStringWriter writer = new UnicodeStringWriter();
        gson.toJson(value, (Appendable)writer);
        return writer.toString();
    }

    public static <T> String toJson(T value, String ... ignorePropertyNames) {
        if (ArrayUtils.isEmpty(ignorePropertyNames)) {
            return JsonUtil.toJson(value);
        }
        UnicodeStringWriter writer = new UnicodeStringWriter();
        new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{128}).addSerializationExclusionStrategy((ExclusionStrategy)new PropertyNameExclusionStrategy(ignorePropertyNames)).create().toJson(value, (Appendable)writer);
        return writer.toString();
    }

    public static <T> String toJson(T value, boolean toUnicode, String ... ignorePropertyNames) {
        if (toUnicode) {
            return JsonUtil.toJson(value, ignorePropertyNames);
        }
        if (ArrayUtils.isEmpty(ignorePropertyNames)) {
            return gson.toJson(value);
        }
        return new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{128}).addSerializationExclusionStrategy((ExclusionStrategy)new PropertyNameExclusionStrategy(ignorePropertyNames)).create().toJson(value);
    }

    public static <T> String toJson(T value, boolean toUnicode, boolean ignoreNull, String ... ignorePropertyNames) {
        if (ignoreNull) {
            return JsonUtil.toJson(value, toUnicode, ignorePropertyNames);
        }
        return new GsonBuilder().serializeNulls().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{128}).addSerializationExclusionStrategy((ExclusionStrategy)new PropertyNameExclusionStrategy(ignorePropertyNames)).create().toJson(value);
    }

    public static <T> T fromJson(String json, Class<T> clazz) {
        if (StringUtils.isEmpty(json)) {
            return null;
        }
        if (clazz == null) {
            return (T)gson.fromJson(json, new TypeToken<Map<String, Object>>(){}.getType());
        }
        return (T)gson.fromJson(json, clazz);
    }

    public static <T> T fromJson(String json, Type typeOfT) {
        if (StringUtils.isEmpty(json)) {
            return null;
        }
        return (T)gson.fromJson(json, typeOfT);
    }

    public static <T> T fromJson(String json, TypeRef<T> typeRef) {
        if (StringUtils.isEmpty(json)) {
            return null;
        }
        return (T)gson.fromJson(json, typeRef.getType());
    }
}

