/*
 * Decompiled with CFR 0.152.
 */
package com.mzlion.core.lang;

import com.mzlion.core.lang.CollectionUtils;
import com.mzlion.core.lang.ObjectUtils;
import com.mzlion.core.lang.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;

public class ArrayUtils {
    private ArrayUtils() {
        throw new UnsupportedOperationException();
    }

    public static boolean isArray(Object obj) {
        return obj != null && obj.getClass().isArray();
    }

    public static boolean isEmpty(char[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(boolean[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(byte[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(short[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(int[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(long[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(float[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(double[] array) {
        return array == null || array.length == 0;
    }

    public static <T> boolean isEmpty(T[] array) {
        return array == null || array.length == 0;
    }

    public static <T> boolean isNotEmpty(T[] array) {
        return array != null && array.length != 0;
    }

    public static <T> boolean isEmptyElement(T[] array) {
        boolean empty = ArrayUtils.isEmpty(array);
        if (!empty) {
            empty = false;
            for (T element : array) {
                if (element == null) {
                    empty = true;
                } else if (element instanceof String) {
                    empty = StringUtils.isEmpty((String)element);
                }
                if (!empty) continue;
                return true;
            }
        }
        return empty;
    }

    public static <T> boolean containsElement(T[] array, T element) {
        if (ArrayUtils.isEmpty(array)) {
            return false;
        }
        for (T arrayEle : array) {
            if (!ObjectUtils.nullSafeEquals(arrayEle, element)) continue;
            return true;
        }
        return false;
    }

    public static String toString(Object[] array) {
        return ArrayUtils.toString(array, ",");
    }

    public static String toString(Object[] array, String delimiter) {
        if (ArrayUtils.isEmpty(array)) {
            return "";
        }
        if (delimiter == null) {
            delimiter = "";
        }
        StringBuilder builder = new StringBuilder();
        int length = array.length - 1;
        int i = 0;
        while (true) {
            builder.append(String.valueOf(array[i]));
            if (i == length) {
                return builder.toString();
            }
            builder.append(delimiter);
            ++i;
        }
    }

    public static String toString(char[] array, String delimiter) {
        if (ArrayUtils.isEmpty(array)) {
            return "";
        }
        if (delimiter == null) {
            delimiter = "";
        }
        StringBuilder builder = new StringBuilder();
        int length = array.length - 1;
        int i = 0;
        while (true) {
            builder.append(array[i]);
            if (i == length) {
                return builder.toString();
            }
            builder.append(delimiter);
            ++i;
        }
    }

    public static String toString(char[] array) {
        return ArrayUtils.toString(array, ",");
    }

    public static String toString(boolean[] array, String delimiter) {
        if (ArrayUtils.isEmpty(array)) {
            return "";
        }
        if (delimiter == null) {
            delimiter = "";
        }
        StringBuilder builder = new StringBuilder();
        int length = array.length - 1;
        int i = 0;
        while (true) {
            builder.append(array[i]);
            if (i == length) {
                return builder.toString();
            }
            builder.append(delimiter);
            ++i;
        }
    }

    public static String toString(boolean[] array) {
        return ArrayUtils.toString(array, ",");
    }

    public static String toString(byte[] array, String delimiter) {
        if (ArrayUtils.isEmpty(array)) {
            return "";
        }
        if (delimiter == null) {
            delimiter = "";
        }
        StringBuilder builder = new StringBuilder();
        int length = array.length - 1;
        int i = 0;
        while (true) {
            builder.append(array[i]);
            if (i == length) {
                return builder.toString();
            }
            builder.append(delimiter);
            ++i;
        }
    }

    public static String toString(byte[] array) {
        return ArrayUtils.toString(array, ",");
    }

    public static String toString(short[] array, String delimiter) {
        if (ArrayUtils.isEmpty(array)) {
            return "";
        }
        if (delimiter == null) {
            delimiter = "";
        }
        StringBuilder builder = new StringBuilder();
        int length = array.length - 1;
        int i = 0;
        while (true) {
            builder.append(array[i]);
            if (i == length) {
                return builder.toString();
            }
            builder.append(delimiter);
            ++i;
        }
    }

    public static String toString(short[] array) {
        return ArrayUtils.toString(array, ",");
    }

    public static String toString(int[] array) {
        return ArrayUtils.toString(array, ",");
    }

    public static String toString(int[] array, String delimiter) {
        if (ArrayUtils.isEmpty(array)) {
            return "";
        }
        if (delimiter == null) {
            delimiter = "";
        }
        StringBuilder builder = new StringBuilder();
        int length = array.length - 1;
        int i = 0;
        while (true) {
            builder.append(array[i]);
            if (i == length) {
                return builder.toString();
            }
            builder.append(delimiter);
            ++i;
        }
    }

    public static String toString(long[] array) {
        return ArrayUtils.toString(array, ",");
    }

    public static String toString(long[] array, String delimiter) {
        if (ArrayUtils.isEmpty(array)) {
            return "";
        }
        if (delimiter == null) {
            delimiter = "";
        }
        StringBuilder builder = new StringBuilder();
        int length = array.length - 1;
        int i = 0;
        while (true) {
            builder.append(array[i]);
            if (i == length) {
                return builder.toString();
            }
            builder.append(delimiter);
            ++i;
        }
    }

    public static String toString(float[] array, String delimiter) {
        if (ArrayUtils.isEmpty(array)) {
            return "";
        }
        if (delimiter == null) {
            delimiter = "";
        }
        StringBuilder builder = new StringBuilder();
        int length = array.length - 1;
        int i = 0;
        while (true) {
            builder.append(array[i]);
            if (i == length) {
                return builder.toString();
            }
            builder.append(delimiter);
            ++i;
        }
    }

    public static String toString(float[] array) {
        return ArrayUtils.toString(array, ",");
    }

    public static String toString(double[] array, String delimiter) {
        if (ArrayUtils.isEmpty(array)) {
            return "";
        }
        if (delimiter == null) {
            delimiter = "";
        }
        StringBuilder builder = new StringBuilder();
        int length = array.length - 1;
        int i = 0;
        while (true) {
            builder.append(array[i]);
            if (i == length) {
                return builder.toString();
            }
            builder.append(delimiter);
            ++i;
        }
    }

    public static String toString(double[] array) {
        return ArrayUtils.toString(array, ",");
    }

    public static String[] addStringToArray(String[] array, String addStr) {
        if (ArrayUtils.isEmpty(array)) {
            return new String[]{addStr};
        }
        String[] newArray = new String[array.length + 1];
        System.arraycopy(array, 0, newArray, 0, array.length);
        newArray[array.length] = addStr;
        return newArray;
    }

    public static String[] concatStringArrays(String[] arr1, String[] arr2) {
        if (ArrayUtils.isEmpty(arr1)) {
            return arr2;
        }
        if (ArrayUtils.isEmpty(arr2)) {
            return arr1;
        }
        String[] newArr = new String[arr1.length + arr2.length];
        System.arraycopy(arr1, 0, newArr, 0, arr1.length);
        System.arraycopy(arr2, 0, newArr, arr1.length, arr2.length);
        return newArr;
    }

    public static String[] mergeStringArrays(String[] array1, String[] array2) {
        if (ArrayUtils.isEmpty(array1)) {
            return array2;
        }
        if (ArrayUtils.isEmpty(array2)) {
            return array1;
        }
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(Arrays.asList(array1));
        for (String str : array2) {
            if (result.contains(str)) continue;
            result.add(str);
        }
        return CollectionUtils.toStringArray(result);
    }

    public static String[] sortStringArray(String[] array) {
        if (ArrayUtils.isEmpty(array)) {
            return new String[0];
        }
        Arrays.sort(array);
        return array;
    }
}

