/*
 * Decompiled with CFR 0.152.
 */
package com.mzlion.core.lang;

import com.mzlion.core.lang.CollectionUtils;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class StringUtils {
    public static final String EMPTY_STRING = "";

    public static boolean isEmpty(CharSequence str) {
        return !StringUtils.hasLength(str);
    }

    public static boolean isEmpty(String str) {
        return StringUtils.isEmpty((CharSequence)str);
    }

    public static boolean hasLength(CharSequence str) {
        return str != null && str.length() > 0;
    }

    public static boolean hasLength(String str) {
        return StringUtils.hasLength((CharSequence)str);
    }

    public static boolean hasText(CharSequence str) {
        if (!StringUtils.hasLength(str)) {
            return false;
        }
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean hasText(String str) {
        return StringUtils.hasText((CharSequence)str);
    }

    public static boolean containsWhitespace(CharSequence str) {
        if (!StringUtils.hasLength(str)) {
            return false;
        }
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            if (!Character.isWhitespace(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean containsWhitespace(String str) {
        return StringUtils.containsWhitespace((CharSequence)str);
    }

    public static String trim(String str) {
        if (!StringUtils.hasLength(str)) {
            return str;
        }
        StringBuilder sb = new StringBuilder(str);
        while (sb.length() > 0 && Character.isWhitespace(sb.charAt(0))) {
            sb.deleteCharAt(0);
        }
        while (sb.length() > 0 && Character.isWhitespace(sb.charAt(sb.length() - 1))) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static String trimLeftWhiteSpace(String str) {
        if (!StringUtils.hasLength(str)) {
            return str;
        }
        StringBuilder sb = new StringBuilder(str);
        while (sb.length() > 0 && Character.isWhitespace(sb.charAt(0))) {
            sb.deleteCharAt(0);
        }
        return sb.toString();
    }

    public static String trimRightWhiteSpace(String str) {
        if (!StringUtils.hasLength(str)) {
            return str;
        }
        StringBuilder sb = new StringBuilder(str);
        while (sb.length() > 0 && Character.isWhitespace(sb.charAt(sb.length() - 1))) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static boolean startsWithIgnoreCase(String str, String prefix) {
        if (null == str || null == prefix) {
            return false;
        }
        if (str.startsWith(prefix)) {
            return true;
        }
        if (str.length() < prefix.length()) {
            return false;
        }
        String lowerCaseStr = str.substring(0, prefix.length()).toLowerCase();
        String lowerCasePrefix = prefix.toLowerCase();
        return lowerCasePrefix.equals(lowerCaseStr);
    }

    public static boolean endsWithIgnoreCase(String str, String suffix) {
        if (null == str || null == suffix) {
            return false;
        }
        if (str.endsWith(suffix)) {
            return true;
        }
        if (str.length() < suffix.length()) {
            return false;
        }
        String lowerStr = str.substring(str.length() - suffix.length()).toLowerCase();
        String lowerSuffix = suffix.toLowerCase();
        return lowerSuffix.equals(lowerStr);
    }

    public static String replace(String str, String oldPattern, String newPattern) {
        if (!StringUtils.hasLength(str) || !StringUtils.hasLength(oldPattern) || null == newPattern) {
            return str;
        }
        StringBuilder sb = new StringBuilder();
        int pos = 0;
        int index = str.indexOf(oldPattern, pos);
        int patternLen = oldPattern.length();
        while (index >= 0) {
            sb.append(str.substring(pos, index));
            sb.append(newPattern);
            pos = index + patternLen;
            index = str.indexOf(oldPattern, pos);
        }
        sb.append(str.substring(pos));
        return sb.toString();
    }

    public static String delete(String str, String pattern) {
        return StringUtils.replace(str, pattern, EMPTY_STRING);
    }

    public static String capitalize(String str) {
        return StringUtils.changeCharacterCase(str, 0, true);
    }

    public static String unCapitalize(String str) {
        return StringUtils.changeCharacterCase(str, 0, false);
    }

    public static String changeCharacterCase(String str, int index, boolean capital) {
        if (!StringUtils.hasLength(str)) {
            return str;
        }
        int pos = index < 0 ? str.length() + index : index;
        StringBuilder sb = new StringBuilder(str.length());
        sb.append(str.subSequence(0, pos));
        if (capital) {
            sb.append(Character.toUpperCase(str.charAt(pos)));
        } else {
            sb.append(Character.toLowerCase(str.charAt(pos)));
        }
        sb.append(str.substring(pos + 1));
        return sb.toString();
    }

    public static String[] splitAtFirst(String toSplit, String delimiter) {
        if (StringUtils.isEmpty(toSplit)) {
            return new String[0];
        }
        if (StringUtils.isEmpty(delimiter)) {
            return new String[0];
        }
        int offset = toSplit.indexOf(delimiter);
        if (offset < 0) {
            return new String[0];
        }
        return new String[]{toSplit.substring(0, offset), toSplit.substring(offset + delimiter.length())};
    }

    public static String[] split(String toSplit) {
        return StringUtils.split(toSplit, ",");
    }

    public static String[] split(String toSplit, String delimiter) {
        if (StringUtils.isEmpty(toSplit)) {
            return new String[0];
        }
        if (StringUtils.isEmpty(delimiter)) {
            return new String[0];
        }
        StringTokenizer st = new StringTokenizer(toSplit, delimiter);
        ArrayList<String> values = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (!StringUtils.hasText(token)) continue;
            values.add(token);
        }
        if (CollectionUtils.isNotEmpty(values)) {
            String[] splitOfStrs = new String[values.size()];
            values.toArray(splitOfStrs);
            return splitOfStrs;
        }
        return new String[0];
    }

    public static String toUnderline(String name) {
        return StringUtils.toUnderline(name, false);
    }

    public static String toUnderline(String name, boolean upper) {
        if (!StringUtils.hasText(name)) {
            return null;
        }
        StringBuilder builder = new StringBuilder(name.length());
        char[] chars = name.toCharArray();
        int length = chars.length;
        for (int i = 0; i < length; ++i) {
            char ch = chars[i];
            if (Character.isUpperCase(ch)) {
                if (i != 0) {
                    builder.append("_");
                }
                builder.append(upper ? ch : Character.toLowerCase(ch));
                continue;
            }
            builder.append(upper ? Character.toUpperCase(ch) : ch);
        }
        return builder.toString();
    }

    public static String toCamelCase(String name) {
        if (!StringUtils.hasText(name)) {
            return name;
        }
        boolean headerFirstUnderline = false;
        StringBuilder builder = new StringBuilder(name.length());
        char[] chars = name.toCharArray();
        int length = chars.length;
        for (int i = 0; i < length; ++i) {
            char ch = chars[i];
            if (ch == '_') {
                if (chars[i + 1] == '_') {
                    if (i != 0) continue;
                    headerFirstUnderline = true;
                    continue;
                }
                if (i == 0) {
                    headerFirstUnderline = true;
                }
                ch = chars[++i];
                if (headerFirstUnderline) {
                    builder.append(Character.toLowerCase(ch));
                    headerFirstUnderline = false;
                    continue;
                }
                builder.append(Character.toUpperCase(ch));
                continue;
            }
            builder.append(Character.toLowerCase(ch));
        }
        return builder.toString();
    }
}

