/*
 * Decompiled with CFR 0.152.
 */
package com.mzlion.core.reflect;

import com.mzlion.core.exceptions.FatalBeanException;
import com.mzlion.core.lang.ArrayUtils;
import com.mzlion.core.lang.Assert;
import com.mzlion.core.lang.CollectionUtils;
import com.mzlion.core.reflect.FieldFilter;
import com.mzlion.core.reflect.StaticFieldFilter;
import com.mzlion.core.reflect.TransientFieldFilter;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.WeakHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectionUtils {
    private static final Logger logger = LoggerFactory.getLogger(ReflectionUtils.class);
    private static final WeakHashMap<Class<?>, List<Field>> declaredFieldsCache = new WeakHashMap(255);
    private static final WeakHashMap<Class<?>, Method[]> declaredMethodCache = new WeakHashMap(255);

    private ReflectionUtils() {
        throw new UnsupportedOperationException();
    }

    public static List<Field> getDeclaredFields(Class<?> targetClass) {
        Assert.notNull(targetClass, "Target class must not be null.");
        List<Field> declaredFields = declaredFieldsCache.get(targetClass);
        if (declaredFields == null) {
            logger.debug(" It cannot find field list in cache for targetClass->{}", targetClass);
            declaredFields = new ArrayList<Field>();
            for (Class<?> currentClass = targetClass; currentClass != null; currentClass = currentClass.getSuperclass()) {
                Field[] fields = currentClass.getDeclaredFields();
                Collections.addAll(declaredFields, fields);
            }
            logger.debug(" Reflect fields success,then put then into cache container.targetClass->{},fields->{}", targetClass, declaredFields);
            declaredFieldsCache.put(targetClass, declaredFields.size() == 0 ? Collections.emptyList() : declaredFields);
        } else {
            logger.debug(" ===> The cache exist class [{}] reflection.", (Object)targetClass.getName());
        }
        return declaredFields;
    }

    public static List<Field> getDeclaredFields(Class<?> targetClass, FieldFilter ... fieldFilters) {
        List<Field> fieldList = ReflectionUtils.getDeclaredFields(targetClass);
        if (CollectionUtils.isEmpty(fieldList)) {
            return fieldList;
        }
        if (ArrayUtils.isEmpty(fieldFilters)) {
            return fieldList;
        }
        ArrayList<Field> filterFieldList = new ArrayList<Field>(fieldList.size());
        for (Field field : fieldList) {
            boolean filter = false;
            for (FieldFilter fieldFilter : fieldFilters) {
                if (!fieldFilter.matches(field)) continue;
                filter = true;
                break;
            }
            if (filter) continue;
            filterFieldList.add(field);
        }
        return filterFieldList;
    }

    public static Field findField(Class<?> targetClass, String fieldName) {
        return ReflectionUtils.findField(targetClass, fieldName, null);
    }

    public static Field findField(Class<?> targetClass, String fieldName, Class<?> fieldType) {
        Assert.notNull(targetClass, "Target class must not be null.");
        Assert.isTrue(fieldName != null || fieldType != null, "Either fieldName or fieldType of the field must be specified.");
        for (Class<?> searchType = targetClass; Object.class != searchType && searchType != null; searchType = searchType.getSuperclass()) {
            List<Field> declaredFields = ReflectionUtils.getDeclaredFields(searchType);
            for (Field declaredField : declaredFields) {
                if (fieldName != null && !fieldName.equals(declaredField.getName()) || fieldType != null && !fieldType.equals(declaredField.getType())) continue;
                return declaredField;
            }
        }
        return null;
    }

    public static String toString(Object object) {
        return ReflectionUtils.toString(object, false, false);
    }

    public static String toString(Object object, boolean outputStatics) {
        return ReflectionUtils.toString(object, outputStatics, true);
    }

    public static String toString(Object object, boolean outputStatics, boolean outputTransients) {
        if (object == null) {
            return null;
        }
        Class<?> targetClass = object.getClass();
        if (Number.class.isAssignableFrom(targetClass) || String.class.equals(targetClass) || Boolean.class.isAssignableFrom(targetClass) || Character.class.isAssignableFrom(targetClass)) {
            return String.format("%s[%s]", targetClass.getSimpleName(), object);
        }
        ArrayList<FieldFilter> fieldFilterList = new ArrayList<FieldFilter>();
        if (!outputStatics) {
            fieldFilterList.add(new StaticFieldFilter());
        }
        if (!outputTransients) {
            fieldFilterList.add(new TransientFieldFilter());
        }
        FieldFilter[] fieldFilters = new FieldFilter[fieldFilterList.size()];
        fieldFilterList.toArray(fieldFilters);
        List<Field> declaredFields = ReflectionUtils.getDeclaredFields(targetClass, fieldFilters);
        AccessibleObject[] fieldArray = new Field[declaredFields.size()];
        declaredFields.toArray(fieldArray);
        StringBuilder builder = new StringBuilder(targetClass.getSimpleName());
        builder.append('{');
        AccessibleObject.setAccessible(fieldArray, true);
        int length = fieldArray.length;
        for (int i = 0; i < length; ++i) {
            AccessibleObject field = fieldArray[i];
            if (i > 0) {
                builder.append(", ");
            }
            try {
                Object value = ((Field)field).get(object);
                if (Number.class.isAssignableFrom(((Field)field).getType())) {
                    builder.append(((Field)field).getName()).append('=').append(value);
                    continue;
                }
                if (String.class.isAssignableFrom(((Field)field).getType())) {
                    builder.append(((Field)field).getName()).append("='").append(value).append("'");
                    continue;
                }
                builder.append(((Field)field).getName()).append('=').append(value);
                continue;
            }
            catch (ReflectiveOperationException e) {
                throw new FatalBeanException(e);
            }
        }
        builder.append('}');
        return builder.toString();
    }
}

