/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.api;

import com.netflix.spectator.api.ArrayTagSet;
import com.netflix.spectator.api.Clock;
import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.DefaultId;
import com.netflix.spectator.api.DistributionSummary;
import com.netflix.spectator.api.Gauge;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Meter;
import com.netflix.spectator.api.NoopCounter;
import com.netflix.spectator.api.NoopDistributionSummary;
import com.netflix.spectator.api.NoopGauge;
import com.netflix.spectator.api.NoopTimer;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.RegistryConfig;
import com.netflix.spectator.api.SwapCounter;
import com.netflix.spectator.api.SwapDistributionSummary;
import com.netflix.spectator.api.SwapGauge;
import com.netflix.spectator.api.SwapMaxGauge;
import com.netflix.spectator.api.SwapTimer;
import com.netflix.spectator.api.Tag;
import com.netflix.spectator.api.Timer;
import com.netflix.spectator.api.Utils;
import com.netflix.spectator.api.patterns.PolledMeter;
import com.netflix.spectator.impl.Config;
import com.netflix.spectator.impl.Preconditions;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRegistry
implements Registry {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Clock clock;
    private final RegistryConfig config;
    private final ConcurrentHashMap<Id, Meter> meters;
    private final ConcurrentHashMap<Id, Object> state;

    public AbstractRegistry(Clock clock) {
        this(clock, Config.defaultConfig());
    }

    public AbstractRegistry(Clock clock, RegistryConfig config) {
        this.clock = clock;
        this.config = config;
        this.meters = new ConcurrentHashMap();
        this.state = new ConcurrentHashMap();
    }

    protected abstract Counter newCounter(Id var1);

    protected abstract DistributionSummary newDistributionSummary(Id var1);

    protected abstract Timer newTimer(Id var1);

    protected abstract Gauge newGauge(Id var1);

    protected abstract Gauge newMaxGauge(Id var1);

    @Override
    public final Clock clock() {
        return this.clock;
    }

    @Override
    public final RegistryConfig config() {
        return this.config;
    }

    @Override
    public final Id createId(String name) {
        return new DefaultId(name);
    }

    @Override
    public final Id createId(String name, Iterable<Tag> tags) {
        return new DefaultId(name, ArrayTagSet.create(tags));
    }

    private void logTypeError(Id id, Class<?> desired, Class<?> found) {
        String dtype = desired.getName();
        String ftype = found.getName();
        String msg = String.format("cannot access '%s' as a %s, it already exists as a %s", id, dtype, ftype);
        this.propagate(new IllegalStateException(msg));
    }

    private Meter compute(Meter m, Meter fallback) {
        return this.meters.size() >= this.config.maxNumberOfMeters() ? fallback : m;
    }

    @Override
    public void register(Meter meter) {
        PolledMeter.monitorMeter(this, meter);
    }

    @Override
    public ConcurrentMap<Id, Object> state() {
        return this.state;
    }

    @Override
    public final Counter counter(Id id) {
        Counter c = this.getOrCreate(id, Counter.class, NoopCounter.INSTANCE, this::newCounter);
        return new SwapCounter((Registry)this, id, c);
    }

    @Override
    public final DistributionSummary distributionSummary(Id id) {
        DistributionSummary ds = this.getOrCreate(id, DistributionSummary.class, NoopDistributionSummary.INSTANCE, this::newDistributionSummary);
        return new SwapDistributionSummary((Registry)this, id, ds);
    }

    @Override
    public final Timer timer(Id id) {
        Timer t = this.getOrCreate(id, Timer.class, NoopTimer.INSTANCE, this::newTimer);
        return new SwapTimer((Registry)this, id, t);
    }

    @Override
    public final Gauge gauge(Id id) {
        Gauge g = this.getOrCreate(id, Gauge.class, NoopGauge.INSTANCE, this::newGauge);
        return new SwapGauge((Registry)this, id, g);
    }

    @Override
    public final Gauge maxGauge(Id id) {
        Gauge g = this.getOrCreate(id, Gauge.class, NoopGauge.INSTANCE, this::newMaxGauge);
        return new SwapMaxGauge((Registry)this, id, g);
    }

    protected <T extends Meter> T getOrCreate(Id id, Class<T> cls, T dflt, Function<Id, T> factory) {
        try {
            Preconditions.checkNotNull(id, "id");
            Meter m = Utils.computeIfAbsent(this.meters, id, i -> this.compute((Meter)factory.apply((Id)i), dflt));
            if (!cls.isAssignableFrom(m.getClass())) {
                this.logTypeError(id, cls, m.getClass());
                m = dflt;
            }
            return (T)m;
        }
        catch (Exception e) {
            this.propagate(e);
            return dflt;
        }
    }

    @Override
    public final Meter get(Id id) {
        return this.meters.get(id);
    }

    @Override
    public final Iterator<Meter> iterator() {
        return this.meters.values().iterator();
    }

    protected void removeExpiredMeters() {
        Iterator<Map.Entry<Id, Meter>> it = this.meters.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Id, Meter> entry = it.next();
            Meter m = entry.getValue();
            if (!m.hasExpired()) continue;
            it.remove();
        }
    }
}

