/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.swagger;

import com.networknt.config.Config;
import com.networknt.handler.MiddlewareHandler;
import com.networknt.status.Status;
import com.networknt.swagger.ApiNormalisedPath;
import com.networknt.swagger.NormalisedPath;
import com.networknt.swagger.SwaggerHelper;
import com.networknt.swagger.SwaggerOperation;
import com.networknt.utility.ModuleRegistry;
import io.swagger.models.HttpMethod;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.AttachmentKey;
import io.undertow.util.HttpString;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwaggerHandler
implements MiddlewareHandler {
    static final Logger logger = LoggerFactory.getLogger(SwaggerHandler.class);
    public static final String CONFIG_NAME = "swagger";
    static final String STATUS_INVALID_REQUEST_PATH = "ERR10007";
    static final String STATUS_METHOD_NOT_ALLOWED = "ERR10008";
    public static AttachmentKey<SwaggerOperation> SWAGGER_OPERATION = AttachmentKey.create(SwaggerOperation.class);
    private volatile HttpHandler next;

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        ApiNormalisedPath requestPath = new ApiNormalisedPath(exchange.getRequestURI());
        Optional<NormalisedPath> maybeApiPath = SwaggerHelper.findMatchingApiPath(requestPath);
        if (!maybeApiPath.isPresent()) {
            Status status = new Status(STATUS_INVALID_REQUEST_PATH, new Object[]{requestPath.normalised()});
            exchange.setStatusCode(status.getStatusCode());
            exchange.getResponseSender().send(status.toString());
            return;
        }
        NormalisedPath swaggerPathString = maybeApiPath.get();
        Path swaggerPath = SwaggerHelper.swagger.getPath(swaggerPathString.original());
        HttpMethod httpMethod = HttpMethod.valueOf((String)exchange.getRequestMethod().toString());
        Operation operation = (Operation)swaggerPath.getOperationMap().get(httpMethod);
        if (operation == null) {
            Status status = new Status(STATUS_METHOD_NOT_ALLOWED, new Object[0]);
            exchange.setStatusCode(status.getStatusCode());
            exchange.getResponseSender().send(status.toString());
            return;
        }
        SwaggerOperation swaggerOperation = new SwaggerOperation(swaggerPathString, swaggerPath, httpMethod, operation);
        String endpoint = swaggerPathString.normalised() + "@" + httpMethod.toString().toLowerCase();
        swaggerOperation.setEndpoint(endpoint);
        exchange.getRequestHeaders().add(new HttpString("endpoint"), endpoint);
        exchange.putAttachment(SWAGGER_OPERATION, (Object)swaggerOperation);
        this.next.handleRequest(exchange);
    }

    public HttpHandler getNext() {
        return this.next;
    }

    public MiddlewareHandler setNext(HttpHandler next) {
        Handlers.handlerNotNull((HttpHandler)next);
        this.next = next;
        return this;
    }

    public boolean isEnabled() {
        return SwaggerHelper.swagger != null;
    }

    public void register() {
        ModuleRegistry.registerModule((String)SwaggerHandler.class.getName(), (Map)Config.getInstance().getJsonMapConfig(CONFIG_NAME), null);
    }
}

