/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.validator;

import com.networknt.body.BodyHandler;
import com.networknt.status.Status;
import com.networknt.swagger.NormalisedPath;
import com.networknt.swagger.SwaggerOperation;
import com.networknt.validator.SchemaValidator;
import com.networknt.validator.parameter.ParameterValidators;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.parameters.Parameter;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderValues;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestValidator {
    static final Logger logger = LoggerFactory.getLogger(RequestValidator.class);
    static final String VALIDATOR_REQUEST_BODY_UNEXPECTED = "ERR11013";
    static final String VALIDATOR_REQUEST_BODY_MISSING = "ERR11014";
    static final String VALIDATOR_REQUEST_PARAMETER_HEADER_MISSING = "ERR11017";
    static final String VALIDATOR_REQUEST_PARAMETER_QUERY_MISSING = "ERR11000";
    private final SchemaValidator schemaValidator;
    private final ParameterValidators parameterValidators;

    public RequestValidator(SchemaValidator schemaValidator) {
        this.schemaValidator = Objects.requireNonNull(schemaValidator, "A schema validator is required");
        this.parameterValidators = new ParameterValidators(schemaValidator);
    }

    public Status validateRequest(NormalisedPath requestPath, HttpServerExchange exchange, SwaggerOperation swaggerOperation) {
        Objects.requireNonNull(requestPath, "A request path is required");
        Objects.requireNonNull(exchange, "An exchange is required");
        Objects.requireNonNull(swaggerOperation, "An swagger operation is required");
        Status status = this.validatePathParameters(requestPath, swaggerOperation);
        if (status != null) {
            return status;
        }
        status = this.validateQueryParameters(exchange, swaggerOperation);
        if (status != null) {
            return status;
        }
        status = this.validateHeader(exchange, swaggerOperation);
        if (status != null) {
            return status;
        }
        Object body = exchange.getAttachment(BodyHandler.REQUEST_BODY);
        status = this.validateRequestBody(body, swaggerOperation);
        return status;
    }

    private Status validateRequestBody(Object requestBody, SwaggerOperation swaggerOperation) {
        Optional<Parameter> bodyParameter = swaggerOperation.getOperation().getParameters().stream().filter(p -> p.getIn().equalsIgnoreCase("body")).findFirst();
        if (requestBody != null && !bodyParameter.isPresent()) {
            return new Status(VALIDATOR_REQUEST_BODY_UNEXPECTED, new Object[]{swaggerOperation.getMethod(), swaggerOperation.getPathString().original()});
        }
        if (!bodyParameter.isPresent()) {
            return null;
        }
        if (requestBody == null) {
            if (bodyParameter.isPresent() && bodyParameter.get().getRequired()) {
                return new Status(VALIDATOR_REQUEST_BODY_MISSING, new Object[]{swaggerOperation.getMethod(), swaggerOperation.getPathString().original()});
            }
            return null;
        }
        return this.schemaValidator.validate(requestBody, ((BodyParameter)bodyParameter.get()).getSchema());
    }

    private Status validatePathParameters(NormalisedPath requestPath, SwaggerOperation swaggerOperation) {
        Status status = null;
        for (int i = 0; i < swaggerOperation.getPathString().parts().size(); ++i) {
            if (!swaggerOperation.getPathString().isParam(i)) continue;
            String paramName = swaggerOperation.getPathString().paramName(i);
            String paramValue = requestPath.part(i);
            Optional<Parameter> parameter = swaggerOperation.getOperation().getParameters().stream().filter(p -> p.getIn().equalsIgnoreCase("PATH")).filter(p -> p.getName().equalsIgnoreCase(paramName)).findFirst();
            if (!parameter.isPresent()) continue;
            status = this.parameterValidators.validate(paramValue, parameter.get());
        }
        return status;
    }

    private Status validateQueryParameters(HttpServerExchange exchange, SwaggerOperation swaggerOperation) {
        Optional<Status> optional = swaggerOperation.getOperation().getParameters().stream().filter(p -> p.getIn().equalsIgnoreCase("QUERY")).map(p -> this.validateQueryParameter(exchange, swaggerOperation, (Parameter)p)).filter(s -> s != null).findFirst();
        if (optional.isPresent()) {
            return optional.get();
        }
        return null;
    }

    private Status validateQueryParameter(HttpServerExchange exchange, SwaggerOperation swaggerOperation, Parameter queryParameter) {
        Collection queryParameterValues = (Collection)exchange.getQueryParameters().get(queryParameter.getName());
        if (queryParameterValues == null || queryParameterValues.isEmpty()) {
            if (queryParameter.getRequired()) {
                return new Status(VALIDATOR_REQUEST_PARAMETER_QUERY_MISSING, new Object[]{queryParameter.getName(), swaggerOperation.getPathString().original()});
            }
        } else {
            Optional<Status> optional = queryParameterValues.stream().map(v -> this.parameterValidators.validate((String)v, queryParameter)).filter(s -> s != null).findFirst();
            if (optional.isPresent()) {
                return optional.get();
            }
        }
        return null;
    }

    private Status validateHeader(HttpServerExchange exchange, SwaggerOperation swaggerOperation) {
        Optional<Status> optional = swaggerOperation.getOperation().getParameters().stream().filter(p -> p.getIn().equalsIgnoreCase("header")).map(p -> this.validateHeader(exchange, swaggerOperation, (Parameter)p)).filter(s -> s != null).findFirst();
        if (optional.isPresent()) {
            return optional.get();
        }
        return null;
    }

    private Status validateHeader(HttpServerExchange exchange, SwaggerOperation swaggerOperation, Parameter headerParameter) {
        HeaderValues headerValues = exchange.getRequestHeaders().get(headerParameter.getName());
        if (headerValues == null || headerValues.isEmpty()) {
            if (headerParameter.getRequired()) {
                return new Status(VALIDATOR_REQUEST_PARAMETER_HEADER_MISSING, new Object[]{headerParameter.getName(), swaggerOperation.getPathString().original()});
            }
        } else {
            Optional<Status> optional = headerValues.stream().map(v -> this.parameterValidators.validate((String)v, headerParameter)).filter(s -> s != null).findFirst();
            if (optional.isPresent()) {
                return optional.get();
            }
        }
        return null;
    }
}

