/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.validator;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.networknt.config.Config;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.ValidationMessage;
import com.networknt.status.Status;
import com.networknt.utility.Util;
import io.swagger.models.Model;
import io.swagger.models.Swagger;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.StringProperty;
import io.swagger.util.Json;
import java.util.Objects;
import java.util.Set;

public class SchemaValidator {
    private static final String DEFINITIONS_FIELD = "definitions";
    static final String VALIDATOR_SCHEMA_INVALID_JSON = "ERR11003";
    static final String VALIDATOR_SCHEMA = "ERR11004";
    private final Swagger api;
    private JsonNode definitions;

    public SchemaValidator() {
        this(null);
    }

    public SchemaValidator(Swagger api) {
        this.api = api;
    }

    public Status validate(Object value, Property schema) {
        return this.doValidate(value, (Object)schema);
    }

    public Status validate(Object value, Model schema) {
        return this.doValidate(value, (Object)schema);
    }

    private Status doValidate(Object value, Object schema) {
        Objects.requireNonNull(schema, "A schema is required");
        Status status = null;
        Set processingReport = null;
        try {
            JsonNode schemaObject = Json.mapper().readTree(Json.pretty((Object)schema));
            if (this.api != null) {
                if (this.definitions == null) {
                    this.definitions = Json.mapper().readTree(Json.pretty((Object)this.api.getDefinitions()));
                }
                ((ObjectNode)schemaObject).set(DEFINITIONS_FIELD, this.definitions);
            }
            JsonSchema jsonSchema = new JsonSchemaFactory(Config.getInstance().getMapper()).getSchema(schemaObject);
            JsonNode content = Json.mapper().valueToTree(value);
            processingReport = jsonSchema.validate(content);
        }
        catch (JsonParseException e) {
            return new Status(VALIDATOR_SCHEMA_INVALID_JSON, new Object[]{e.getMessage()});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (processingReport != null && processingReport.size() > 0) {
            ValidationMessage vm = (ValidationMessage)processingReport.iterator().next();
            status = new Status(VALIDATOR_SCHEMA, new Object[]{vm.getMessage()});
        }
        return status;
    }

    public Status validate(String value, Property schema) {
        return this.doValidate(value, (Object)schema);
    }

    public Status validate(String value, Model schema) {
        return this.doValidate(value, (Object)schema);
    }

    private Status doValidate(String value, Object schema) {
        Objects.requireNonNull(schema, "A schema is required");
        Status status = null;
        Set processingReport = null;
        try {
            JsonNode schemaObject = Json.mapper().readTree(Json.pretty((Object)schema));
            if (this.api != null) {
                if (this.definitions == null) {
                    this.definitions = Json.mapper().readTree(Json.pretty((Object)this.api.getDefinitions()));
                }
                ((ObjectNode)schemaObject).set(DEFINITIONS_FIELD, this.definitions);
            }
            JsonSchema jsonSchema = new JsonSchemaFactory(Config.getInstance().getMapper()).getSchema(schemaObject);
            String normalisedValue = value;
            if (schema instanceof StringProperty) {
                normalisedValue = Util.quote((String)value);
            }
            JsonNode content = Json.mapper().readTree(normalisedValue);
            processingReport = jsonSchema.validate(content);
        }
        catch (JsonParseException e) {
            return new Status(VALIDATOR_SCHEMA_INVALID_JSON, new Object[]{e.getMessage()});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (processingReport != null && processingReport.size() > 0) {
            ValidationMessage vm = (ValidationMessage)processingReport.iterator().next();
            status = new Status(VALIDATOR_SCHEMA, new Object[]{vm.getMessage()});
        }
        return status;
    }
}

