/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.validator.parameter;

import com.networknt.status.Status;
import com.networknt.validator.parameter.BaseParameterValidator;
import io.swagger.models.parameters.SerializableParameter;

public class IntegerParameterValidator
extends BaseParameterValidator {
    @Override
    public String supportedParameterType() {
        return "integer";
    }

    @Override
    protected Status doValidate(String value, SerializableParameter parameter) {
        if (parameter.getFormat().equalsIgnoreCase("int32")) {
            try {
                Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                return this.failFormatValidation(value, parameter, "int32");
            }
        }
        if (parameter.getFormat().equalsIgnoreCase("int64")) {
            try {
                Long.parseLong(value);
            }
            catch (NumberFormatException e) {
                return this.failFormatValidation(value, parameter, "int64");
            }
        }
        Long d = Long.parseLong(value);
        if (parameter.getMinimum() != null && (double)d.longValue() < parameter.getMinimum()) {
            return new Status("ERR11011", new Object[]{value, parameter.getName(), parameter.getMinimum()});
        }
        if (parameter.getMaximum() != null && (double)d.longValue() > parameter.getMaximum()) {
            return new Status("ERR11012", new Object[]{value, parameter.getName(), parameter.getMaximum()});
        }
        return null;
    }

    private Status failFormatValidation(String value, SerializableParameter parameter, String format) {
        return new Status("ERR11010", new Object[]{value, parameter.getName(), this.supportedParameterType(), format});
    }
}

