/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.validator.parameter;

import com.networknt.status.Status;
import com.networknt.validator.parameter.BaseParameterValidator;
import io.swagger.models.parameters.SerializableParameter;

public class NumberParameterValidator
extends BaseParameterValidator {
    @Override
    public String supportedParameterType() {
        return "number";
    }

    @Override
    protected Status doValidate(String value, SerializableParameter parameter) {
        if (parameter.getFormat().equalsIgnoreCase("float")) {
            try {
                Float.parseFloat(value);
            }
            catch (NumberFormatException e) {
                return this.failFormatValidation(value, parameter, "float");
            }
        }
        if (parameter.getFormat().equalsIgnoreCase("double")) {
            try {
                Double.parseDouble(value);
            }
            catch (NumberFormatException e) {
                return this.failFormatValidation(value, parameter, "double");
            }
        }
        Double d = Double.parseDouble(value);
        if (parameter.getMinimum() != null && d < parameter.getMinimum()) {
            return new Status("ERR11011", new Object[]{value, parameter.getName(), parameter.getMinimum()});
        }
        if (parameter.getMaximum() != null && d > parameter.getMaximum()) {
            return new Status("ERR11012", new Object[]{value, parameter.getName(), parameter.getMaximum()});
        }
        return null;
    }

    private Status failFormatValidation(String value, SerializableParameter parameter, String format) {
        return new Status("ERR11010", new Object[]{value, parameter.getName(), this.supportedParameterType(), format});
    }
}

