/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.flow.ActualReturnTypeFlow;
import com.oracle.graal.pointsto.flow.InvokeTypeFlow;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.flow.context.BytecodeLocation;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.typestate.TypeState;
import com.oracle.graal.pointsto.util.AnalysisError;
import com.oracle.graal.pointsto.util.ConcurrentLightHashSet;
import java.util.Collection;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.java.MethodCallTargetNode;

public abstract class AbstractVirtualInvokeTypeFlow
extends InvokeTypeFlow {
    protected final ConcurrentLightHashSet<AnalysisMethod> callees;

    protected AbstractVirtualInvokeTypeFlow(Invoke invoke, MethodCallTargetNode target, TypeFlow<?>[] actualParameters, ActualReturnTypeFlow actualReturn, BytecodeLocation location) {
        super(invoke, target, actualParameters, actualReturn, location);
        assert (target.invokeKind() == CallTargetNode.InvokeKind.Virtual || target.invokeKind() == CallTargetNode.InvokeKind.Interface);
        this.callees = new ConcurrentLightHashSet();
    }

    protected AbstractVirtualInvokeTypeFlow(BigBang bb, MethodFlowsGraph methodFlows, AbstractVirtualInvokeTypeFlow original) {
        super(bb, methodFlows, original);
        this.callees = new ConcurrentLightHashSet();
    }

    @Override
    public boolean addState(BigBang bb, TypeState add, boolean postFlow) {
        throw AnalysisError.shouldNotReachHere("The VirtualInvokeTypeFlow should not be updated directly.");
    }

    @Override
    public void update(BigBang bb) {
        throw AnalysisError.shouldNotReachHere("The VirtualInvokeTypeFlow should not be updated directly.");
    }

    @Override
    public abstract void onObservedUpdate(BigBang var1);

    protected boolean addCallee(AnalysisMethod callee) {
        boolean add = this.callees.addElement(callee);
        if (this.isClone()) {
            ((AbstractVirtualInvokeTypeFlow)this.originalInvoke).addCallee(callee);
        }
        return add;
    }

    @Override
    public final Collection<AnalysisMethod> getCallees() {
        return this.callees.getElements();
    }

    @Override
    public String toString() {
        return "VirtualInvoke<" + ((MethodCallTargetNode)this.getSource()).targetMethod().format("%h.%n") + ">:" + this.getState();
    }
}

