/*
 * Decompiled with CFR 0.152.
 */
package com.parkingwang.okhttp3.LogInterceptor;

import com.parkingwang.okhttp3.LogInterceptor.formatter.JSONFormatter;
import java.io.EOFException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import okhttp3.Connection;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.http.HttpHeaders;
import okhttp3.internal.platform.Platform;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;

public class LogInterceptor
implements Interceptor {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static final AtomicInteger ID_GENERATOR = new AtomicInteger(0);
    private final Logger logger;

    public LogInterceptor() {
        this(new Logger(){

            @Override
            public void log(String message) {
                Platform.get().log(5, message, null);
            }
        });
    }

    public LogInterceptor(Logger logger) {
        this.logger = logger;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Response response;
        Request request = chain.request();
        int id = ID_GENERATOR.incrementAndGet();
        String LOG_PREFIX = "[" + id + " request]";
        RequestBody requestBody = request.body();
        boolean hasRequestBody = requestBody != null;
        Connection connection = chain.connection();
        Protocol protocol = connection != null ? connection.protocol() : Protocol.HTTP_1_1;
        String requestStartMessage = "--> " + request.method() + ' ' + request.url() + ' ' + protocol;
        this.logger.log(LOG_PREFIX + requestStartMessage);
        if (hasRequestBody) {
            if (requestBody.contentType() != null) {
                this.logger.log(LOG_PREFIX + "Content-Type: " + requestBody.contentType());
            }
            if (requestBody.contentLength() != -1L) {
                this.logger.log(LOG_PREFIX + "Content-Length: " + requestBody.contentLength());
            }
        }
        Headers headers = request.headers();
        int count = headers.size();
        for (int i = 0; i < count; ++i) {
            String name = headers.name(i);
            if ("Content-Type".equalsIgnoreCase(name) || "Content-Length".equalsIgnoreCase(name)) continue;
            this.logger.log(LOG_PREFIX + name + ": " + headers.value(i));
        }
        if (!hasRequestBody) {
            this.logger.log(LOG_PREFIX + "--> END " + request.method());
        } else if (this.bodyEncoded(request.headers())) {
            this.logger.log(LOG_PREFIX + "--> END " + request.method() + " (encoded body omitted)");
        } else {
            Buffer buffer = new Buffer();
            requestBody.writeTo((BufferedSink)buffer);
            Charset charset = UTF8;
            MediaType contentType = requestBody.contentType();
            if (contentType != null) {
                charset = contentType.charset(UTF8);
            }
            if (LogInterceptor.isPlaintext(buffer)) {
                String bufferString = buffer.readString(charset);
                this.logger.log(LOG_PREFIX + bufferString);
                if (contentType != null && "json".equals(contentType.subtype())) {
                    this.logger.log(LOG_PREFIX + "\n" + JSONFormatter.formatJSON(bufferString));
                }
                this.logger.log(LOG_PREFIX + "--> END " + request.method() + " (" + requestBody.contentLength() + "-byte body)");
            } else {
                this.logger.log(LOG_PREFIX + "--> END " + request.method() + " (binary " + requestBody.contentLength() + "-byte body omitted)");
            }
        }
        LOG_PREFIX = "[" + id + " response]";
        long startNs = System.nanoTime();
        try {
            response = chain.proceed(request);
        }
        catch (Exception e) {
            this.logger.log(LOG_PREFIX + "<-- HTTP FAILED: " + e);
            throw e;
        }
        long tookMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNs);
        ResponseBody responseBody = response.body();
        long contentLength = responseBody.contentLength();
        this.logger.log(LOG_PREFIX + "<-- " + response.code() + ' ' + response.message() + ' ' + response.request().url() + " (" + tookMs + "ms" + ')');
        Headers headers2 = response.headers();
        int count2 = headers2.size();
        for (int i = 0; i < count2; ++i) {
            this.logger.log(LOG_PREFIX + headers2.name(i) + ": " + headers2.value(i));
        }
        if (!HttpHeaders.hasBody((Response)response)) {
            this.logger.log(LOG_PREFIX + "<-- END HTTP");
        } else if (this.bodyEncoded(response.headers())) {
            this.logger.log(LOG_PREFIX + "<-- END HTTP (encoded body omitted)");
        } else {
            BufferedSource source = responseBody.source();
            source.request(Long.MAX_VALUE);
            Buffer buffer = source.buffer();
            Charset charset = UTF8;
            MediaType contentType = responseBody.contentType();
            if (contentType != null) {
                try {
                    charset = contentType.charset(UTF8);
                }
                catch (UnsupportedCharsetException e) {
                    this.logger.log(LOG_PREFIX + "");
                    this.logger.log(LOG_PREFIX + "Couldn't decode the response body; charset is likely malformed.");
                    this.logger.log(LOG_PREFIX + "<-- END HTTP");
                    return response;
                }
            }
            if (!LogInterceptor.isPlaintext(buffer)) {
                this.logger.log(LOG_PREFIX + "<-- END HTTP (binary " + buffer.size() + "-byte body omitted)");
                return response;
            }
            if (contentLength != 0L) {
                String bufferString = buffer.clone().readString(charset);
                this.logger.log(LOG_PREFIX + bufferString);
                if (contentType != null && "json".equals(contentType.subtype())) {
                    this.logger.log(LOG_PREFIX + "\n" + JSONFormatter.formatJSON(bufferString));
                }
            }
            this.logger.log(LOG_PREFIX + "<-- END HTTP (" + buffer.size() + "-byte body)");
        }
        return response;
    }

    static boolean isPlaintext(Buffer buffer) {
        try {
            Buffer prefix = new Buffer();
            long byteCount = buffer.size() < 64L ? buffer.size() : 64L;
            buffer.copyTo(prefix, 0L, byteCount);
            for (int i = 0; i < 16 && !prefix.exhausted(); ++i) {
                int codePoint = prefix.readUtf8CodePoint();
                if (!Character.isISOControl(codePoint) || Character.isWhitespace(codePoint)) continue;
                return false;
            }
            return true;
        }
        catch (EOFException e) {
            return false;
        }
    }

    private boolean bodyEncoded(Headers headers) {
        String contentEncoding = headers.get("Content-Encoding");
        return contentEncoding != null && !contentEncoding.equalsIgnoreCase("identity");
    }

    public static interface Logger {
        public void log(String var1);
    }
}

