/*
 * Decompiled with CFR 0.152.
 */
package com.parkingwang.okhttp3.LogInterceptor.formatter;

import com.parkingwang.okhttp3.LogInterceptor.formatter.JSONFormatter;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonReader;
import com.squareup.moshi.Moshi;
import java.io.IOException;
import okio.Buffer;
import okio.BufferedSource;

class MoshiFormatter
extends JSONFormatter {
    private final Moshi MOSHI = new Moshi.Builder().build();
    private final JsonAdapter<Object> ADAPTER = this.MOSHI.adapter(Object.class).indent("    ");

    MoshiFormatter() {
    }

    @Override
    String format(String source) {
        Buffer buffer = new Buffer().writeUtf8(source);
        JsonReader reader = JsonReader.of((BufferedSource)buffer);
        try {
            return this.ADAPTER.toJson(reader.readJsonValue());
        }
        catch (IOException e) {
            return "";
        }
    }

    static JSONFormatter buildIfSupported() {
        try {
            Class.forName("com.squareup.moshi.Moshi");
            return new MoshiFormatter();
        }
        catch (ClassNotFoundException ignore) {
            return null;
        }
    }
}

