/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.cli.reporter.json;

import com.pinterest.ktlint.cli.reporter.core.api.KtlintCliError;
import com.pinterest.ktlint.cli.reporter.core.api.ReporterV2;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\tH\u0016J\f\u0010\u000f\u001a\u00020\u0007*\u00020\u0007H\u0002R \u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/pinterest/ktlint/cli/reporter/json/JsonReporter;", "Lcom/pinterest/ktlint/cli/reporter/core/api/ReporterV2;", "out", "Ljava/io/PrintStream;", "(Ljava/io/PrintStream;)V", "acc", "Ljava/util/concurrent/ConcurrentHashMap;", "", "", "Lcom/pinterest/ktlint/cli/reporter/core/api/KtlintCliError;", "afterAll", "", "onLintError", "file", "ktlintCliError", "escapeJsonValue", "ktlint-cli-reporter-json"})
@SourceDebugExtension(value={"SMAP\nJsonReporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonReporter.kt\ncom/pinterest/ktlint/cli/reporter/json/JsonReporter\n+ 2 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,58:1\n72#2,2:59\n1#3:61\n1045#4:62\n*S KotlinDebug\n*F\n+ 1 JsonReporter.kt\ncom/pinterest/ktlint/cli/reporter/json/JsonReporter\n*L\n20#1:59,2\n20#1:61\n27#1:62\n*E\n"})
public final class JsonReporter
implements ReporterV2 {
    @NotNull
    private final PrintStream out;
    @NotNull
    private final ConcurrentHashMap<String, List<KtlintCliError>> acc;

    public JsonReporter(@NotNull PrintStream out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        this.out = out;
        this.acc = new ConcurrentHashMap();
    }

    public void onLintError(@NotNull String file, @NotNull KtlintCliError ktlintCliError) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)ktlintCliError, (String)"ktlintCliError");
        if (ktlintCliError.getStatus() != KtlintCliError.Status.FORMAT_IS_AUTOCORRECTED) {
            ConcurrentMap $this$getOrPut$iv = this.acc;
            boolean $i$f$getOrPut = false;
            Object object = $this$getOrPut$iv.get(file);
            if (object == null) {
                boolean bl = false;
                List default$iv = new ArrayList();
                boolean bl2 = false;
                object = $this$getOrPut$iv.putIfAbsent(file, default$iv);
                if (object == null) {
                    object = default$iv;
                }
            }
            ((List)object).add(ktlintCliError);
        }
    }

    public void afterAll() {
        this.out.println("[");
        int indexLast = this.acc.size() - 1;
        Set<Map.Entry<String, List<KtlintCliError>>> set = this.acc.entrySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-entries>(...)");
        Iterable $this$sortedBy$iv = set;
        boolean $i$f$sortedBy = false;
        Iterator iterator = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)((String)it.getKey()));
                it = (Map.Entry)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)((String)it.getKey()))));
            }
        }).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int index = n++;
            Map.Entry entry = (Map.Entry)iterator.next();
            Intrinsics.checkNotNull((Object)entry);
            String file = (String)entry.getKey();
            List errList = (List)entry.getValue();
            this.out.println("    {");
            StringBuilder stringBuilder = new StringBuilder().append("        \"file\": \"");
            Intrinsics.checkNotNull((Object)file);
            this.out.println(stringBuilder.append(this.escapeJsonValue(file)).append("\",").toString());
            this.out.println("        \"errors\": [");
            int errIndexLast = errList.size() - 1;
            Iterator iterator2 = errList.iterator();
            int n2 = 0;
            while (iterator2.hasNext()) {
                KtlintCliError err;
                int errIndex = n2++;
                KtlintCliError $this$afterAll_u24lambda_u242 = err = (KtlintCliError)iterator2.next();
                boolean bl = false;
                this.out.println("            {");
                this.out.println("                \"line\": " + $this$afterAll_u24lambda_u242.getLine() + ',');
                this.out.println("                \"column\": " + $this$afterAll_u24lambda_u242.getCol() + ',');
                this.out.println("                \"message\": \"" + this.escapeJsonValue($this$afterAll_u24lambda_u242.getDetail()) + "\",");
                this.out.println("                \"rule\": \"" + $this$afterAll_u24lambda_u242.getRuleId() + '\"');
                this.out.println("            }" + (errIndex != errIndexLast ? "," : ""));
            }
            this.out.println("        ]");
            this.out.println("    }" + (index != indexLast ? "," : ""));
        }
        this.out.println("]");
    }

    private final String escapeJsonValue(String $this$escapeJsonValue) {
        return StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)$this$escapeJsonValue, (String)"\\", (String)"\\\\", (boolean)false, (int)4, null), (String)"\"", (String)"\\\"", (boolean)false, (int)4, null), (String)"\b", (String)"\\b", (boolean)false, (int)4, null), (String)"\n", (String)"\\n", (boolean)false, (int)4, null), (String)"\r", (String)"\\r", (boolean)false, (int)4, null), (String)"\t", (String)"\\t", (boolean)false, (int)4, null);
    }

    public void after(@NotNull String file) {
        ReporterV2.DefaultImpls.after((ReporterV2)this, (String)file);
    }

    public void before(@NotNull String file) {
        ReporterV2.DefaultImpls.before((ReporterV2)this, (String)file);
    }

    public void beforeAll() {
        ReporterV2.DefaultImpls.beforeAll((ReporterV2)this);
    }
}

