/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.metrics;

import com.puppycrawl.tools.checkstyle.FileStatefulCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.utils.CheckUtils;
import com.puppycrawl.tools.checkstyle.utils.CommonUtils;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

@FileStatefulCheck
public abstract class AbstractClassCouplingCheck
extends AbstractCheck {
    private static final String DOT = ".";
    private static final Set<String> DEFAULT_EXCLUDED_CLASSES = Collections.unmodifiableSet(Arrays.stream(new String[]{"boolean", "byte", "char", "double", "float", "int", "long", "short", "void", "Boolean", "Byte", "Character", "Double", "Float", "Integer", "Long", "Short", "Void", "Object", "Class", "String", "StringBuffer", "StringBuilder", "ArrayIndexOutOfBoundsException", "Exception", "RuntimeException", "IllegalArgumentException", "IllegalStateException", "IndexOutOfBoundsException", "NullPointerException", "Throwable", "SecurityException", "UnsupportedOperationException", "List", "ArrayList", "Deque", "Queue", "LinkedList", "Set", "HashSet", "SortedSet", "TreeSet", "Map", "HashMap", "SortedMap", "TreeMap"}).collect(Collectors.toSet()));
    private static final Set<String> DEFAULT_EXCLUDED_PACKAGES = Collections.emptySet();
    private final List<Pattern> excludeClassesRegexps = new ArrayList<Pattern>();
    private Set<String> excludedClasses = DEFAULT_EXCLUDED_CLASSES;
    private Set<String> excludedPackages = DEFAULT_EXCLUDED_PACKAGES;
    private int max;
    private FileContext fileContext;

    protected AbstractClassCouplingCheck(int defaultMax) {
        this.max = defaultMax;
        this.excludeClassesRegexps.add(CommonUtils.createPattern("^$"));
    }

    protected abstract String getLogMessageId();

    @Override
    public final int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    public final void setMax(int max) {
        this.max = max;
    }

    public final void setExcludedClasses(String ... excludedClasses) {
        this.excludedClasses = Collections.unmodifiableSet(Arrays.stream(excludedClasses).collect(Collectors.toSet()));
    }

    public void setExcludeClassesRegexps(String ... from) {
        this.excludeClassesRegexps.addAll(Arrays.stream((Object[])from.clone()).map(CommonUtils::createPattern).collect(Collectors.toSet()));
    }

    public final void setExcludedPackages(String ... excludedPackages) {
        List invalidIdentifiers = Arrays.stream(excludedPackages).filter(packageName -> !CommonUtils.isName(packageName)).collect(Collectors.toList());
        if (!invalidIdentifiers.isEmpty()) {
            throw new IllegalArgumentException("the following values are not valid identifiers: " + invalidIdentifiers.stream().collect(Collectors.joining(", ", "[", "]")));
        }
        this.excludedPackages = Collections.unmodifiableSet(Arrays.stream(excludedPackages).collect(Collectors.toSet()));
    }

    @Override
    public final void beginTree(DetailAST ast) {
        this.fileContext = new FileContext();
    }

    @Override
    public void visitToken(DetailAST ast) {
        switch (ast.getType()) {
            case 16: {
                this.visitPackageDef(ast);
                break;
            }
            case 30: {
                this.fileContext.registerImport(ast);
                break;
            }
            case 14: 
            case 15: 
            case 154: 
            case 157: {
                this.visitClassDef(ast);
                break;
            }
            case 13: {
                this.fileContext.visitType(ast);
                break;
            }
            case 136: {
                this.fileContext.visitLiteralNew(ast);
                break;
            }
            case 81: {
                this.fileContext.visitLiteralThrows(ast);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown type: " + (Object)((Object)ast));
            }
        }
    }

    @Override
    public void leaveToken(DetailAST ast) {
        switch (ast.getType()) {
            case 14: 
            case 15: 
            case 154: 
            case 157: {
                this.leaveClassDef();
                break;
            }
        }
    }

    private void visitPackageDef(DetailAST pkg) {
        FullIdent ident = FullIdent.createFullIdent(pkg.getLastChild().getPreviousSibling());
        this.fileContext.setPackageName(ident.getText());
    }

    private void visitClassDef(DetailAST classDef) {
        String className = classDef.findFirstToken(58).getText();
        this.fileContext.createNewClassContext(className, classDef.getLineNo(), classDef.getColumnNo());
    }

    private void leaveClassDef() {
        this.fileContext.checkCurrentClassAndRestorePrevious();
    }

    private class ClassContext {
        private final FileContext parentContext;
        private final Set<String> referencedClassNames = new TreeSet<String>();
        private final String className;
        private final int lineNo;
        private final int columnNo;

        ClassContext(FileContext parentContext, String className, int lineNo, int columnNo) {
            this.parentContext = parentContext;
            this.className = className;
            this.lineNo = lineNo;
            this.columnNo = columnNo;
        }

        public void visitLiteralThrows(DetailAST literalThrows) {
            for (DetailAST childAST = literalThrows.getFirstChild(); childAST != null; childAST = childAST.getNextSibling()) {
                if (childAST.getType() == 74) continue;
                this.addReferencedClassName(childAST);
            }
        }

        public void visitType(DetailAST ast) {
            String fullTypeName = CheckUtils.createFullType(ast).getText();
            this.addReferencedClassName(fullTypeName);
        }

        public void visitLiteralNew(DetailAST ast) {
            this.addReferencedClassName(ast.getFirstChild());
        }

        private void addReferencedClassName(DetailAST ast) {
            String fullIdentName = FullIdent.createFullIdent(ast).getText();
            this.addReferencedClassName(fullIdentName);
        }

        private void addReferencedClassName(String referencedClassName) {
            if (this.isSignificant(referencedClassName)) {
                this.referencedClassNames.add(referencedClassName);
            }
        }

        public void checkCoupling() {
            this.referencedClassNames.remove(this.className);
            this.referencedClassNames.remove(this.parentContext.getPackageName() + AbstractClassCouplingCheck.DOT + this.className);
            if (this.referencedClassNames.size() > AbstractClassCouplingCheck.this.max) {
                AbstractClassCouplingCheck.this.log(this.lineNo, this.columnNo, AbstractClassCouplingCheck.this.getLogMessageId(), this.referencedClassNames.size(), AbstractClassCouplingCheck.this.max, this.referencedClassNames.toString());
            }
        }

        private boolean isSignificant(String candidateClassName) {
            boolean result;
            boolean bl = result = !AbstractClassCouplingCheck.this.excludedClasses.contains(candidateClassName) && !this.isFromExcludedPackage(candidateClassName);
            if (result) {
                for (Pattern pattern : AbstractClassCouplingCheck.this.excludeClassesRegexps) {
                    if (!pattern.matcher(candidateClassName).matches()) continue;
                    result = false;
                    break;
                }
            }
            return result;
        }

        private boolean isFromExcludedPackage(String candidateClassName) {
            String classNameWithPackage = candidateClassName;
            if (!candidateClassName.contains(AbstractClassCouplingCheck.DOT)) {
                classNameWithPackage = this.parentContext.getClassNameWithPackage(candidateClassName).orElse("");
            }
            boolean isFromExcludedPackage = false;
            if (classNameWithPackage.contains(AbstractClassCouplingCheck.DOT)) {
                int lastDotIndex = classNameWithPackage.lastIndexOf(AbstractClassCouplingCheck.DOT);
                String packageName = classNameWithPackage.substring(0, lastDotIndex);
                isFromExcludedPackage = packageName.startsWith("java.lang") || AbstractClassCouplingCheck.this.excludedPackages.contains(packageName);
            }
            return isFromExcludedPackage;
        }
    }

    private class FileContext {
        private final Map<String, String> importedClassPackage = new HashMap<String, String>();
        private final Deque<ClassContext> classesContexts = new ArrayDeque<ClassContext>();
        private String packageName = "";
        private ClassContext classContext = new ClassContext(this, "", 0, 0);

        private FileContext() {
        }

        public String getPackageName() {
            return this.packageName;
        }

        public void setPackageName(String packageName) {
            this.packageName = packageName;
        }

        public void registerImport(DetailAST imp) {
            FullIdent ident = FullIdent.createFullIdent(imp.getLastChild().getPreviousSibling());
            String fullName = ident.getText();
            if (fullName.charAt(fullName.length() - 1) != '*') {
                int lastDot = fullName.lastIndexOf(AbstractClassCouplingCheck.DOT);
                this.importedClassPackage.put(fullName.substring(lastDot + 1), fullName);
            }
        }

        public Optional<String> getClassNameWithPackage(String className) {
            return Optional.ofNullable(this.importedClassPackage.get(className));
        }

        public void createNewClassContext(String className, int lineNo, int columnNo) {
            this.classesContexts.push(this.classContext);
            this.classContext = new ClassContext(this, className, lineNo, columnNo);
        }

        public void checkCurrentClassAndRestorePrevious() {
            this.classContext.checkCoupling();
            this.classContext = this.classesContexts.pop();
        }

        public void visitType(DetailAST ast) {
            this.classContext.visitType(ast);
        }

        public void visitLiteralNew(DetailAST ast) {
            this.classContext.visitLiteralNew(ast);
        }

        public void visitLiteralThrows(DetailAST ast) {
            this.classContext.visitLiteralThrows(ast);
        }
    }
}

