/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.api;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public abstract class AbstractLoader
extends DefaultHandler {
    private final Map<String, String> publicIdToResourceNameMap;
    private final XMLReader parser;

    protected AbstractLoader(String publicId, String dtdResourceName) throws SAXException, ParserConfigurationException {
        this(new HashMap<String, String>(1));
        this.publicIdToResourceNameMap.put(publicId, dtdResourceName);
    }

    protected AbstractLoader(Map<String, String> publicIdToResourceNameMap) throws SAXException, ParserConfigurationException {
        this.publicIdToResourceNameMap = new HashMap<String, String>(publicIdToResourceNameMap);
        SAXParserFactory factory = SAXParserFactory.newInstance();
        FeaturesForVerySecureJavaInstallations.addFeaturesForVerySecureJavaInstallations(factory);
        factory.setValidating(true);
        factory.setNamespaceAware(true);
        this.parser = factory.newSAXParser().getXMLReader();
        this.parser.setContentHandler(this);
        this.parser.setEntityResolver(this);
        this.parser.setErrorHandler(this);
    }

    public void parseInputSource(InputSource inputSource) throws IOException, SAXException {
        this.parser.parse(inputSource);
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        InputSource inputSource;
        if (this.publicIdToResourceNameMap.keySet().contains(publicId)) {
            String dtdResourceName = this.publicIdToResourceNameMap.get(publicId);
            ClassLoader loader = this.getClass().getClassLoader();
            InputStream dtdIs = loader.getResourceAsStream(dtdResourceName);
            inputSource = new InputSource(dtdIs);
        } else {
            inputSource = super.resolveEntity(publicId, systemId);
        }
        return inputSource;
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        throw exception;
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        throw exception;
    }

    public static final class FeaturesForVerySecureJavaInstallations {
        private static final String LOAD_EXTERNAL_DTD = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
        private static final String EXTERNAL_GENERAL_ENTITIES = "http://xml.org/sax/features/external-general-entities";

        private FeaturesForVerySecureJavaInstallations() {
        }

        public static void addFeaturesForVerySecureJavaInstallations(SAXParserFactory factory) throws SAXException, ParserConfigurationException {
            factory.setFeature(LOAD_EXTERNAL_DTD, true);
            factory.setFeature(EXTERNAL_GENERAL_ENTITIES, true);
        }
    }
}

