/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.qvs;

import com.qiniu.common.QiniuException;
import com.qiniu.http.Client;
import com.qiniu.http.Response;
import com.qiniu.qvs.QvsResponse;
import com.qiniu.qvs.model.NameSpace;
import com.qiniu.qvs.model.PatchOperation;
import com.qiniu.util.Auth;
import com.qiniu.util.StringMap;
import com.qiniu.util.UrlUtils;

public class NameSpaceManager {
    private final String apiServer;
    private final Client client;
    private final Auth auth;

    public NameSpaceManager(Auth auth) {
        this(auth, "http://qvs.qiniuapi.com");
    }

    public NameSpaceManager(Auth auth, String apiServer) {
        this(auth, apiServer, new Client());
    }

    public NameSpaceManager(Auth auth, String apiServer, Client client) {
        this.auth = auth;
        this.apiServer = apiServer;
        this.client = client;
    }

    public Response createNameSpace(NameSpace nameSpace) throws QiniuException {
        StringMap params = new StringMap();
        params.putNotNull("name", nameSpace.getName());
        params.putNotNull("desc", nameSpace.getDesc());
        params.putNotNull("accessType", nameSpace.getAccessType());
        params.putNotNull("rtmpUrlType", nameSpace.getRtmpUrlType());
        params.putNotNull("domains", nameSpace.getDomains());
        params.putNotNull("callBack", nameSpace.getCallback());
        params.putNotNull("recordTemplateId", nameSpace.getRecordTemplateId());
        params.putNotNull("snapshotTemplateId", nameSpace.getSnapShotTemplateId());
        params.putNotNull("recordTemplateApplyAll", nameSpace.isRecordTemplateApplyAll());
        params.putNotNull("snapshotTemplateApplyAll", nameSpace.isSnapTemplateApplyAll());
        params.putNotNull("urlMode", nameSpace.getUrlMode());
        params.putNotNull("zone", nameSpace.getZone());
        params.putNotNull("hlsLowLatency", nameSpace.isHlsLowLatency());
        String url = String.format("%s/v1/namespaces", this.apiServer);
        return QvsResponse.post(url, params, this.client, this.auth);
    }

    public Response deleteNameSpace(String namespaceId) throws QiniuException {
        String url = String.format("%s/v1/namespaces/%s", this.apiServer, namespaceId);
        return QvsResponse.delete(url, this.client, this.auth);
    }

    public Response updateNameSpace(String namespaceId, PatchOperation[] patchOperation) throws QiniuException {
        StringMap params = new StringMap().put("operations", patchOperation);
        String url = String.format("%s/v1/namespaces/%s", this.apiServer, namespaceId);
        return QvsResponse.patch(url, params, this.client, this.auth);
    }

    public Response queryNameSpace(String namespaceId) throws QiniuException {
        String url = String.format("%s/v1/namespaces/%s", this.apiServer, namespaceId);
        return QvsResponse.get(url, this.client, this.auth);
    }

    public Response listNameSpace(int offset, int line, String sortBy) throws QiniuException {
        String requestUrl = String.format("%s/v1/namespaces", this.apiServer);
        StringMap map = new StringMap().putNotNull("offset", offset).putNotNull("line", line).putNotEmpty("sortBy", sortBy);
        requestUrl = UrlUtils.composeUrlWithQueries(requestUrl, map);
        return QvsResponse.get(requestUrl, this.client, this.auth);
    }

    public Response disableNameSpace(String namespaceId) throws QiniuException {
        String url = String.format("%s/v1/namespaces/%s/disabled", this.apiServer, namespaceId);
        return QvsResponse.post(url, new StringMap(), this.client, this.auth);
    }

    public Response enableNameSpace(String namespaceId) throws QiniuException {
        String url = String.format("%s/v1/namespaces/%s/enabled", this.apiServer, namespaceId);
        return QvsResponse.post(url, new StringMap(), this.client, this.auth);
    }
}

