/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.api.io;

import com.qiniu.api.config.Config;
import com.qiniu.api.io.PutExtra;
import com.qiniu.api.io.PutRet;
import com.qiniu.api.net.CallRet;
import com.qiniu.api.net.Client;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.entity.mime.content.StringBody;

public class IoApi {
    public static final String UNDEFINED_KEY = "?";
    public static final int NO_CRC32 = 0;
    public static final int AUTO_CRC32 = 1;
    public static final int WITH_CRC32 = 2;

    private static PutRet put(String uptoken, String key, File file, PutExtra extra) {
        if (!file.exists() || !file.canRead()) {
            return new PutRet(new CallRet(400, new Exception("File does not exist or not readable.")));
        }
        if (key == null) {
            key = UNDEFINED_KEY;
        }
        MultipartEntity requestEntity = new MultipartEntity();
        try {
            requestEntity.addPart("token", (ContentBody)new StringBody(uptoken));
            FileBody fileBody = new FileBody(file);
            requestEntity.addPart("file", (ContentBody)fileBody);
            requestEntity.addPart("key", (ContentBody)new StringBody(key, Charset.forName("utf-8")));
            if (extra.checkCrc != 0) {
                if (extra.crc32 == 0L) {
                    return new PutRet(new CallRet(400, new Exception("no crc32 specified!")));
                }
                requestEntity.addPart("crc32", (ContentBody)new StringBody(extra.crc32 + ""));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return new PutRet(new CallRet(400, e));
        }
        String url = Config.UP_HOST;
        CallRet ret = new Client().callWithMultiPart(url, requestEntity);
        return new PutRet(ret);
    }

    private static PutRet putStream(String uptoken, String key, InputStream reader, PutExtra extra) {
        MultipartEntity requestEntity = new MultipartEntity();
        try {
            requestEntity.addPart("token", (ContentBody)new StringBody(uptoken));
            InputStreamBody inputBody = new InputStreamBody(reader, key);
            requestEntity.addPart("file", (ContentBody)inputBody);
            requestEntity.addPart("key", (ContentBody)new StringBody(key, Charset.forName("utf-8")));
            if (extra.checkCrc != 0) {
                if (extra.crc32 == 0L) {
                    return new PutRet(new CallRet(400, new Exception("no crc32 specified!")));
                }
                requestEntity.addPart("crc32", (ContentBody)new StringBody(extra.crc32 + ""));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return new PutRet(new CallRet(400, e));
        }
        String url = Config.UP_HOST;
        CallRet ret = new Client().callWithMultiPart(url, requestEntity);
        return new PutRet(ret);
    }

    public static PutRet Put(String uptoken, String key, InputStream reader, PutExtra extra) {
        if (key == null) {
            key = UNDEFINED_KEY;
        }
        PutRet ret = IoApi.putStream(uptoken, key, reader, extra);
        return ret;
    }

    public static PutRet putFile(String uptoken, String key, String fileName, PutExtra extra) {
        File file = new File(fileName);
        if (extra.checkCrc == 1) {
            try {
                extra.crc32 = IoApi.getCRC32(file);
            }
            catch (Exception e) {
                return new PutRet(new CallRet(400, e));
            }
        }
        return IoApi.put(uptoken, key, file, extra);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getCRC32(File file) throws Exception {
        CRC32 crc32 = new CRC32();
        FileInputStream in = null;
        FilterInputStream checkedInputStream = null;
        long crc = 0L;
        try {
            in = new FileInputStream(file);
            checkedInputStream = new CheckedInputStream(in, crc32);
            while (((CheckedInputStream)checkedInputStream).read() != -1) {
            }
            crc = crc32.getValue();
        }
        finally {
            if (in != null) {
                in.close();
                in = null;
            }
            if (checkedInputStream != null) {
                checkedInputStream.close();
                checkedInputStream = null;
            }
        }
        return crc;
    }
}

