package com.rabbit.blade.api.split;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * <b>Description: 标识孵化Application的注解</b>
 * Created by <a href="mailto:fjd@xdja.com">fanjiandong</a> on 2017/11/20 10:15.
 */
@Retention(RetentionPolicy.SOURCE)
@Target(ElementType.TYPE)
@Documented
public @interface Forked {
    /**
     * @return 孵化Application的标识Tag
     */
    String tag() default "";

    /**
     * @return 是否黏性
     */
    boolean sticky() default false;

    /**
     * @return 优先级
     */
    int priority() default 0;
}
