package com.rabbit.blade.comm.event;

import com.squareup.otto.Bus;
import com.squareup.otto.ThreadEnforcer;

/**
 * <b>Description : 事件总线 </b>
 * <p>Created by <a href="mailto:fanjiandong@outlook.com">fanjiandong</a> on 2017/3/2 9:14.</p>
 */

public class BusProvider {

    private final Bus mainBus;

    public BusProvider() {
        this.mainBus = new Bus(ThreadEnforcer.ANY);
    }

    /**
     * {@link Bus#register(Object)}
     *
     * @param object object whose handler methods should be registered
     */
    public void register(Object object) {
        this.mainBus.register(object);
    }

    /**
     * {@link Bus#unregister(Object)}
     *
     * @param object object whose producer and handler methods should be unregistered.
     */
    public void unregister(Object object) {
        this.mainBus.unregister(object);
    }

    /**
     * {@link Bus#post(Object)}
     *
     * @param event event to post.
     */
    public void post(Object event) {
        this.mainBus.post(event);
    }
}
