package com.rabbit.blade.comm.exeption;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;

/**
 * Created by rabbit-fanjiandong on 2016/3/9.
 * 异常匹配处理类（可匹配用户信息和异常处理动作）
 */

public class OkMatcher {

    private OkMapper globalMapper;

    private OkMapper customMapper;

    private final Context context;

    private final String packageName;

    public OkMatcher(@NonNull Context context,@NonNull String packageName) {
        this.globalMapper = new OkMapper("globalMapper");
        this.customMapper = new OkMapper("customMapper");
        this.context = context;
        this.packageName = packageName;
    }

    /**
     * 匹配异常对应的用户信息
     *
     * @param <T> the type parameter
     * @param ex  异常对象
     * @return 匹配到的用户信息 string
     */
    @Nullable
    public <T extends OkException> String match(@Nullable T ex) {
        String result = this.customMapper.map(ex);
        if (result == null) {
            result = this.globalMapper.map(ex);
        }

        if (!TextUtils.isEmpty(result)) {
            int stringIdentifier = this.context.getResources().getIdentifier(result, "string", packageName);
            if (stringIdentifier != 0) {
                return this.context.getResources().getString(stringIdentifier);
            }
        }
        return null;
    }

    public OkMapper getCustomMapper() {
        return customMapper;
    }

    public OkMapper getGlobalMapper() {
        return globalMapper;
    }
}
