package com.rabbit.blade.comm.util;

import android.support.annotation.NonNull;

import com.orhanobut.logger.Logger;
import com.rabbit.blade.comm.BuildConfig;

/**
 * <b>Description : 日志工具</b>
 * <p>Created by <a href="mailto:fanjiandong@outlook.com">fanjiandong</a> on 2017/3/15 14:52.</p>
 */


public class LogUtil {

    public static final boolean LOG_FLAG = BuildConfig.DEBUG;
    public static final String LOG_TAG = BuildConfig.APPLICATION_ID + "$Logger";

    private static LogUtil logger;

    public static LogUtil getUtils(String tag) {
        if (logger == null) {
            synchronized (LogUtil.class) {
                if (logger == null) {
                    logger = new LogUtil(tag);
                }
            }
        }
        return logger;
    }

    public static LogUtil getUtils() {
        return getUtils(LOG_TAG);
    }

    private LogUtil(String name) {
        Logger.init(name);
    }

    public void i(@NonNull Object str) {
        if (LOG_FLAG) {
            Logger.i(str.toString());
        }

    }

    public void d(@NonNull Object str) {
        if (LOG_FLAG) {
            Logger.d(str.toString());
        }
    }

    public void v(@NonNull Object str) {
        if (LOG_FLAG) {
            Logger.v(str.toString());
        }
    }

    public void w(@NonNull Object str) {
        if (LOG_FLAG) {
            Logger.w(str.toString());
        }
    }

    public void e(@NonNull Object str) {
        if (LOG_FLAG) {
            Logger.e(str.toString());
        }
    }

    public void e(Exception ex) {
        if (LOG_FLAG) {
            Logger.e(ex, null);
        }
    }

    public void e(Throwable tr, String log) {
        if (LOG_FLAG) {
            Logger.e(tr, log);
        }
    }

    public void json(String json) {
        if (LOG_FLAG) {
            Logger.json(json);
        }
    }

    public void xml(String xml) {
        if (LOG_FLAG) {
            Logger.xml(xml);
        }
    }
}
