package com.rabbit.blade.comm.annotation.qua;

import android.support.annotation.NonNull;

import com.rabbit.blade.comm.annotation.DiConfig;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

import javax.inject.Qualifier;


/**
 * <b>Description : 网络连接安全性限定符，包括以下几种类型：</b>
 * <ul>
 * <li>
 * {@link DiConfig#CONN_HTTP}
 * </li>
 * <li>
 * {@link DiConfig#CONN_HTTPS}
 * </li>
 * <li>
 * {@link DiConfig#CONN_HTTP_V0}
 * </li>
 * <li>
 * {@link DiConfig#CONN_HTTPS_V0}
 * </li>
 * <li>
 * {@link DiConfig#CONN_HTTP_V1}
 * </li>
 * <li>
 * {@link DiConfig#CONN_HTTPS_V1}
 * </li>
 * </ul>
 * <p>Created by <a href="mailto:fanjiandong@outlook.com">fanjiandong</a> on 2017/3/1 11:44.</p>
 */
@Documented
@Qualifier
@Retention(RetentionPolicy.CLASS)
public @interface ConnSecurityQua {
    /**
     * 网络连接安全性限定符
     *
     * @return 网络连接安全性限定符
     */
    @NonNull @DiConfig.ConnType String value() default DiConfig.CONN_HTTPS;
}
