package com.rabbit.blade.comm.exeption;

/**
 * Created by rabbit-fanjiandong on 2016/3/8.
 * 网络异常定义
 */

public class NetworkException extends OkException {

    /**
     * The constant CODE_SSL_HANDLE_FAIL.
     */
    public static final String CODE_SSL_HANDLE_FAIL = "sslHandleFail";
    /**
     * The constant CODE_NETWORK_CONN_FAIL.
     */
    public static final String CODE_NETWORK_CONN_FAIL = "networkConnFail";

    /**
     * Instantiates a new Network exception.
     *
     * @param okCode the ok code
     */
    public NetworkException(String okCode) {
        super(okCode);
    }

    /**
     * Instantiates a new Network exception.
     *
     * @param detailMessage the detail message
     * @param okCode        the ok code
     */
    public NetworkException(String detailMessage, String okCode) {
        super(detailMessage, okCode);
    }

    /**
     * Instantiates a new Network exception.
     *
     * @param detailMessage the detail message
     * @param throwable     the throwable
     * @param okCode        the ok code
     */

    public NetworkException(String detailMessage, Throwable throwable, String okCode) {
        super(detailMessage, throwable, okCode);
    }

    /**
     * Instantiates a new Network exception.
     *
     * @param throwable the throwable
     * @param okCode    the ok code
     */
    public NetworkException(Throwable throwable, String okCode) {
        super(throwable, okCode);
    }
}
