package com.rabbit.blade.comm.event;

/**
 * <b>Description : 事件总线 </b>
 * <p>Created by <a href="mailto:fanjiandong@outlook.com">fanjiandong</a> on 2017/3/2 9:14.</p>
 */

public interface BusProvider {

    /**
     * 注册事件消费对象
     *
     * @param object 事件消费对象
     */
    void register(Object object);

    /**
     * 注销事件消费对象
     *
     * @param object 事件消费对象
     */
    void unregister(Object object);

    /**
     * 发送事件
     *
     * @param event 事件对象
     */
    void post(Object event);

    /**
     * 发送黏性事件
     * @param event 事件对象
     */
    void postSticky(Object event);
}
