package com.rabbit.blade.comm.event;

/**
 * <b>Description: </b>
 * Created by <a href="mailto:fjd@xdja.com">fanjiandong</a> on 2017/9/7 19:37.
 */

public class DefaultBusProvider implements BusProvider{

    private static DefaultBusProvider defaultBusProvider;
    public static DefaultBusProvider instance(){
        if (defaultBusProvider == null) {
            synchronized (DefaultBusProvider.class){
                if (defaultBusProvider == null) {
                    defaultBusProvider = new DefaultBusProvider();
                }
            }
        }
        return defaultBusProvider;
    }

    private BusProvider busProvider;

    private DefaultBusProvider(){
        this.busProvider = new EventBusProvider();
    }

    @Override
    public void register(Object object) {
        this.busProvider.register(object);
    }

    @Override
    public void unregister(Object object) {
        this.busProvider.unregister(object);
    }

    @Override
    public void post(Object event) {
        this.busProvider.post(event);
    }

    @Override
    public void postSticky(Object event) {
        this.busProvider.postSticky(event);
    }
}
