package com.rabbit.blade.comm.event;

import android.support.annotation.NonNull;

import com.rabbit.blade.comm.BuildConfig;

import org.greenrobot.eventbus.EventBus;

/**
 * <b>Description : 事件总线 </b>
 * <p>Created by <a href="mailto:fanjiandong@outlook.com">fanjiandong</a> on 2017/3/2 9:14.</p>
 */

public class EventBusProvider implements BusProvider {

    private final EventBus eventBus;

    public EventBusProvider(@NonNull EventBus eventBus) {
        this.eventBus = eventBus;
    }

    public EventBusProvider() {
        this.eventBus = EventBus.builder()
                .throwSubscriberException(BuildConfig.DEBUG)
                .logNoSubscriberMessages(false)
                .sendNoSubscriberEvent(false)
                .installDefaultEventBus();
    }

    @Override
    public void register(Object object) {
        this.eventBus.register(object);
    }

    @Override
    public void unregister(Object object) {
        this.eventBus.unregister(object);
    }

    @Override
    public void post(Object event) {
        this.eventBus.post(event);
    }

    @Override
    public void postSticky(Object event) {
        this.eventBus.postSticky(event);
    }

    public interface EventBusConfig{
        EventBus eventBus();
    }
}
