package com.rabbit.blade.comm.exeption;

/**
 * Created by rabbit-fanjiandong on 2016/3/8.
 * 客户端本地异常定义，如：数据库异常、Json转换异常等
 */

public class ClientException extends OkException {

    /**
     * The constant CODE_UNKNOWN_EXCEPTION.
     */
    public static final String CODE_UNKNOWN_EXCEPTION = "unknownException";

    /**
     * Instantiates a new Client exception.
     *
     * @param throwable the throwable
     * @param okCode    the ok code
     */
    public ClientException(Throwable throwable, String okCode) {
        super(throwable, okCode);
    }

    /**
     * Instantiates a new Client exception.
     *
     * @param okCode the ok code
     */
    public ClientException(String okCode) {
        super(okCode);
    }

    /**
     * Instantiates a new Client exception.
     *
     * @param detailMessage the detail message
     * @param okCode        the ok code
     */
    public ClientException(String detailMessage, String okCode) {
        super(detailMessage, okCode);
    }

    /**
     * Instantiates a new Client exception.
     *
     * @param detailMessage the detail message
     * @param throwable     the throwable
     * @param okCode        the ok code
     */
    public ClientException(String detailMessage, Throwable throwable, String okCode) {
        super(detailMessage, throwable, okCode);
    }
}
