package com.rabbit.blade.comm.exeption;

import android.text.TextUtils;

/**
 * Created by rabbit-fanjiandong on 2016/3/8.
 * 需要明确处理的异常，一般为业务异常，如：后台返回的业务异常，卡操作异常等
 */

public class OkException extends AppException {
    /**
     * 默认的异常错误码定义
     */
    private final String DEFAULT_CODE = getClass().getSimpleName() + "_DefaultCode";
    /**
     * 异常错误码
     */
    private String okCode = DEFAULT_CODE;

    /**
     * Gets ok code.
     *
     * @return {@link #okCode}
     */
    public String getOkCode() {
        return okCode;
    }

    /**
     * Sets ok code.
     *
     * @param okCode {@link #okCode}
     */
    public void setOkCode(String okCode) {
        this.okCode = okCode;
    }

    /**
     * Instantiates a new Ok exception.
     *
     * @param okCode the ok code
     */
    public OkException(String okCode) {
        if (!TextUtils.isEmpty(okCode)) {
            this.okCode = okCode;
        }
    }

    /**
     * Instantiates a new Ok exception.
     *
     * @param detailMessage the detail message
     * @param okCode        the ok code
     */
    public OkException(String detailMessage, String okCode) {
        super(detailMessage);
        if (!TextUtils.isEmpty(okCode)) {
            this.okCode = okCode;
        }
    }

    /**
     * Instantiates a new Ok exception.
     *
     * @param detailMessage the detail message
     * @param throwable     the throwable
     * @param okCode        the ok code
     */
    public OkException(String detailMessage, Throwable throwable, String okCode) {
        super(detailMessage, throwable);
        if (!TextUtils.isEmpty(okCode)) {
            this.okCode = okCode;
        }
    }

    /**
     * Instantiates a new Ok exception.
     *
     * @param throwable the throwable
     * @param okCode    the ok code
     */
    public OkException(Throwable throwable, String okCode) {
        super(throwable);
        if (!TextUtils.isEmpty(okCode)) {
            this.okCode = okCode;
        }
    }

    @Override
    public String toString() {
        return "okCode : " + okCode + "\r\n" + super.toString();
    }
}
