/*
 * Decompiled with CFR 0.152.
 */
package com.rabbit.blade.comm.exeption;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.rabbit.blade.comm.exeption.OkException;
import com.rabbit.blade.comm.util.LogUtil;
import java.util.HashMap;
import java.util.Map;

public class OkMapper {
    private final Map<String, Map<String, String>> errorMapper = new HashMap<String, Map<String, String>>(4);
    private String mark = "OkMapper";

    public OkMapper() {
    }

    public OkMapper(String mark) {
        this();
        this.mark = mark;
    }

    public OkMapper registSingleMapper(@NonNull Class<? extends OkException> cls, @NonNull String errorCode, @NonNull String userMsg) {
        Map<String, String> msgMapper = this.errorMapper.get(cls.getName());
        if (msgMapper == null) {
            msgMapper = new HashMap<String, String>();
            this.registMultipleMapper(cls, msgMapper);
        }
        msgMapper.put(errorCode, userMsg);
        return this;
    }

    public OkMapper unRegistSingleMapper(@NonNull Class<? extends OkException> cls, @NonNull String errorCode) {
        Map<String, String> msgMapper = this.errorMapper.get(cls.getName());
        if (msgMapper != null && msgMapper.containsKey(errorCode)) {
            msgMapper.remove(errorCode);
        }
        return this;
    }

    public OkMapper registMultipleMapper(@NonNull Class<? extends OkException> exeCls, @Nullable Map<String, String> mapper) {
        Map<String, String> msgMapper = this.errorMapper.get(exeCls.getName());
        if (msgMapper != null && mapper != null) {
            msgMapper.putAll(mapper);
        } else {
            this.errorMapper.put(exeCls.getName(), mapper);
        }
        return this;
    }

    public OkMapper unRegistMultipleMapper(@NonNull Class<? extends OkException> exeCls) {
        this.errorMapper.remove(exeCls.getName());
        return this;
    }

    public OkMapper reset() {
        this.errorMapper.clear();
        return this;
    }

    @Nullable
    public String map(@Nullable OkException ex) {
        if (ex == null) {
            LogUtil.getUtils().d(this.mark + " : " + "\u5f02\u5e38\u5bf9\u8c61\u4e3a\u7a7a");
            return null;
        }
        Map<String, String> exceptionMapper = this.errorMapper.get(ex.getClass().getName());
        if (exceptionMapper == null) {
            LogUtil.getUtils().d(this.mark + " : " + "\u8be5\u5f02\u5e38\u5bf9\u5e94\u7684\u7528\u6237\u4fe1\u606f\u5339\u914d\u5668\u4e3a\u7a7a");
            return null;
        }
        String okCode = ex.getOkCode();
        if (TextUtils.isEmpty((CharSequence)okCode)) {
            LogUtil.getUtils().d(this.mark + " : " + "\u8be5\u5f02\u5e38\u9519\u8bef\u7801\u4e3a\u7a7a");
            return null;
        }
        String result = exceptionMapper.get(okCode);
        if (result == null) {
            LogUtil.getUtils().d(this.mark + " : " + "\u672a\u627e\u5230\u8be5\u5f02\u5e38\u4fe1\u606f\u5bf9\u5e94\u7684\u7528\u6237\u4fe1\u606f\u5339\u914d");
            return null;
        }
        return result;
    }
}

