/*
 * Decompiled with CFR 0.152.
 */
package com.rabbit.blade.comm.exeption;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.rabbit.blade.comm.exeption.OkException;
import com.rabbit.blade.comm.exeption.OkMapper;

public class OkMatcher {
    private OkMapper globalMapper = new OkMapper("globalMapper");
    private OkMapper customMapper = new OkMapper("customMapper");
    private final Context context;
    private final String packageName;

    public OkMatcher(@NonNull Context context, @NonNull String packageName) {
        this.context = context;
        this.packageName = packageName;
    }

    @Nullable
    public <T extends OkException> String match(@Nullable T ex) {
        int stringIdentifier;
        String result = this.customMapper.map(ex);
        if (result == null) {
            result = this.globalMapper.map(ex);
        }
        if (!TextUtils.isEmpty((CharSequence)result) && (stringIdentifier = this.context.getResources().getIdentifier(result, "string", this.packageName)) != 0) {
            return this.context.getResources().getString(stringIdentifier);
        }
        return null;
    }

    @NonNull
    public OkMapper getCustomMapper() {
        return this.customMapper;
    }

    @NonNull
    public OkMapper getGlobalMapper() {
        return this.globalMapper;
    }
}

