package com.rabbit.blade.comm.annotation.qua;

import androidx.annotation.NonNull;

import com.rabbit.blade.comm.annotation.DiConfig;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

import javax.inject.Qualifier;


/**
 * <b>Description : 全局通用限定符，包括三个级别:
 * <ul>
 * <li>
 * {@link DiConfig#QUA_APPLICATION Application}
 * </li>
 * <li>
 * {@link DiConfig#QUA_ACTIVITY Activity}
 * </li>
 * <li>
 * {@link DiConfig#QUA_FRAGMENT Fragment}
 * </li>
 * <p>Created by <a href="mailto:fjd@xdja.com">fanjiandong</a> on 2017/3/1 11:39.</p>
 */
@Documented
@Qualifier
@Retention(RetentionPolicy.CLASS)
public @interface AroundQua {
    /**
     * 全局通用限定符
     *
     * @return 全局通用限定符
     */
    @NonNull @DiConfig.QuaType String value() default DiConfig.QUA_ACTIVITY;
}
