package com.rabbit.blade.comm.annotation.qua;

import androidx.annotation.NonNull;

import com.rabbit.blade.comm.annotation.DiConfig;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

import javax.inject.Qualifier;


/**
 * <b>Description : 数据源类型限定符，包括：</b>
 * <ul>
 * <li>{@link DiConfig#TYPE_CLOUD}</li>
 * <li>{@link DiConfig#TYPE_DISK}</li>
 * <li>{@link DiConfig#TYPE_MEMORY}</li>
 * <li>{@link DiConfig#TYPE_DEFAULT}</li>
 * </ul>
 * <p>Created by <a href="mailto:fjd@xdja.com">fanjiandong</a> on 2017/3/1 11:45.</p>
 */
@Documented
@Qualifier
@Retention(RetentionPolicy.CLASS)
public @interface StoreQua {
    /**
     * 数据源类型限定符
     *
     * @return 数据源类型限定符
     */
    @NonNull @DiConfig.StoreType String value() default DiConfig.TYPE_DISK;
}
