package com.rabbit.blade.comm.util;

import android.text.TextUtils;

import androidx.annotation.Nullable;

import com.orhanobut.logger.Logger;
import com.rabbit.blade.comm.BuildConfig;

/**
 * <b>Description : 日志工具</b>
 * <p>Created by <a href="mailto:fjd@xdja.com">fanjiandong</a> on 2017/3/15 14:52.</p>
 */


public class LogUtil {

    public static final boolean LOG_FLAG = BuildConfig.DEBUG;
    public static final String LOG_TAG = "blog";

    private static LogUtil logger;

    public static LogUtil getUtils(String tag) {
        if (logger == null) {
            synchronized (LogUtil.class) {
                if (logger == null) {
                    logger = new LogUtil(tag);
                }
            }
        }
        return logger;
    }

    public static LogUtil getUtils() {
        return getUtils(LOG_TAG);
    }

    private LogUtil(String name) {
        Logger.init(name);
    }

    public void i(@Nullable Object str) {
        if (LOG_FLAG && str != null) {
            Logger.i(str.toString());
        }

    }

    public void d(@Nullable Object str) {
        if (LOG_FLAG && str != null) {
            Logger.d(str.toString());
        }
    }

    public void v(@Nullable Object str) {
        if (LOG_FLAG && str != null) {
            Logger.v(str.toString());
        }
    }

    public void w(@Nullable Object str) {
        if (LOG_FLAG && str != null) {
            Logger.w(str.toString());
        }
    }

    public void e(@Nullable Object str) {
        if (LOG_FLAG && str != null) {
            Logger.e(str.toString());
        }
    }

    public void e(Exception ex) {
        if (LOG_FLAG && ex != null) {
            Logger.e(ex, null);
        }
    }

    public void e(Throwable tr, String log) {
        if (LOG_FLAG && tr != null) {
            Logger.e(tr, log);
        }
    }

    public void json(String json) {
        if (LOG_FLAG && !TextUtils.isEmpty(json)) {
            Logger.json(json);
        }
    }

    public void xml(String xml) {
        if (LOG_FLAG && !TextUtils.isEmpty(xml)) {
            Logger.xml(xml);
        }
    }
}
