/*
 * Decompiled with CFR 0.152.
 */
package com.rabbit.blade.data.cache;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.rabbit.blade.comm.util.LogUtil;
import com.rabbit.blade.data.cache.ConfigCache;
import com.rabbit.blade.data.persistent.PropertyReader;
import java.io.IOException;
import java.util.Map;
import javax.inject.Inject;

public class ConfigCacheImpl
implements ConfigCache {
    public static final String DEFAULT_PROPERTIES = "config.properties";
    private final PropertyReader propertyReader;

    @Inject
    public ConfigCacheImpl(@NonNull PropertyReader reader) {
        this.propertyReader = reader;
        try {
            this.propertyReader.load(DEFAULT_PROPERTIES);
        }
        catch (IOException e) {
            LogUtil.getUtils().w((Object)e.getMessage());
        }
    }

    @Override
    public Map<String, String> getAllConfig() {
        return this.propertyReader.getAll();
    }

    @Override
    public String getConfig(@NonNull String name) {
        return this.propertyReader.get(name);
    }

    @Override
    public String getConfig(@NonNull String name, @Nullable String defaultValue) {
        return this.propertyReader.get(name, defaultValue);
    }
}

