/*
 * Decompiled with CFR 0.152.
 */
package com.rabbit.blade.data.excutor;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.rabbit.blade.domain.excutor.ThreadExecutor;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;

public class ThreadExecutorImpl
implements ThreadExecutor {
    private static final int INITIAL_POOL_SIZE = 3;
    private static final int MAX_POOL_SIZE = 5;
    private static final int KEEP_ALIVE_TIME = 10;
    private static final TimeUnit KEEP_ALIVE_TIME_UNIT = TimeUnit.SECONDS;
    @NonNull
    private final BlockingQueue<Runnable> workQueue = new LinkedBlockingQueue<Runnable>();
    @NonNull
    private final ThreadPoolExecutor threadPoolExecutor;
    @NonNull
    private final ThreadFactory threadFactory = new JobThreadFactory();

    @Inject
    public ThreadExecutorImpl() {
        this.threadPoolExecutor = new ThreadPoolExecutor(3, 5, 10L, KEEP_ALIVE_TIME_UNIT, this.workQueue, this.threadFactory);
    }

    public void execute(@Nullable Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException("Runnable to execute cannot be null");
        }
        this.threadPoolExecutor.execute(runnable);
    }

    public void submit(@Nullable Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException("Runnable to submit cannot be null");
        }
        this.threadPoolExecutor.submit(runnable);
    }

    private static class JobThreadFactory
    implements ThreadFactory {
        private static final String THREAD_NAME = "android_";
        private final int counter = 0;

        private JobThreadFactory() {
        }

        @Override
        @NonNull
        public Thread newThread(@NonNull Runnable runnable) {
            return new Thread(runnable, "android_0");
        }
    }
}

