/*
 * Decompiled with CFR 0.152.
 */
package com.rabbit.blade.data.persistent;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.rabbit.blade.comm.annotation.qua.AroundQua;
import javax.inject.Inject;

public class PreferencesEditor {
    private final SharedPreferences sp;

    @Inject
    public PreferencesEditor(@AroundQua(value="qua_application") Context context) {
        this.sp = PreferenceManager.getDefaultSharedPreferences((Context)context);
    }

    public PreferencesEditor(Context context, @Nullable String prefName) {
        this.sp = !TextUtils.isEmpty((CharSequence)prefName) ? context.getSharedPreferences(prefName, 0) : PreferenceManager.getDefaultSharedPreferences((Context)context);
    }

    public boolean setStringValue(@NonNull String key, @Nullable String value) {
        SharedPreferences.Editor editor = this.sp.edit();
        editor.putString(key, value);
        return editor.commit();
    }

    public boolean setBooleanValue(@NonNull String key, boolean value) {
        SharedPreferences.Editor editor = this.sp.edit();
        editor.putBoolean(key, value);
        return editor.commit();
    }

    public boolean setFloatValue(@NonNull String key, float value) {
        SharedPreferences.Editor editor = this.sp.edit();
        editor.putFloat(key, value);
        return editor.commit();
    }

    public boolean setIntValue(@NonNull String key, int value) {
        SharedPreferences.Editor editor = this.sp.edit();
        editor.putInt(key, value);
        return editor.commit();
    }

    public boolean setLongValue(@NonNull String key, long value) {
        SharedPreferences.Editor editor = this.sp.edit();
        editor.putLong(key, value);
        return editor.commit();
    }

    @Nullable
    public String getStringValue(@NonNull String key, @Nullable String defaultValue) {
        return this.sp.getString(key, defaultValue);
    }

    public Boolean getBooleanValue(@NonNull String key, boolean defaultValue) {
        return this.sp.getBoolean(key, defaultValue);
    }

    public int getIntValue(@NonNull String key, int defaultValue) {
        return this.sp.getInt(key, defaultValue);
    }

    public long getLongValue(@NonNull String key, long defaultValue) {
        return this.sp.getLong(key, defaultValue);
    }

    public float getFloatValue(@NonNull String key, float defaultValue) {
        return this.sp.getFloat(key, defaultValue);
    }

    public boolean containsKey(@NonNull String key) {
        return this.sp.contains(key);
    }

    public void removeKey(@NonNull String key) {
        SharedPreferences.Editor editor = this.sp.edit();
        editor.remove(key);
        editor.apply();
    }
}

