/*
 * Decompiled with CFR 0.152.
 */
package com.rabbit.blade.data.net;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.rabbit.blade.comm.annotation.qua.AroundQua;
import com.rabbit.blade.comm.util.LogUtil;
import com.rabbit.blade.data.cache.ConfigCache;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManagerFactory;
import okhttp3.OkHttpClient;

public class OkHttpsBuilder {
    public static final int CONN_TIME_OUT_UNIT = 30000;
    public static final int READ_TIME_OUT_UNIT = 15000;
    public static final int WRITE_TIME_OUT_UNIT = 15000;
    private final Context context;
    private final ConfigCache configCache;
    private final HostnameVerifier hostnameVerifier;

    @Inject
    public OkHttpsBuilder(@AroundQua(value="qua_application") Context context, ConfigCache configCache) {
        this.context = context;
        this.configCache = configCache;
        this.hostnameVerifier = new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                String hostnameLocal = OkHttpsBuilder.this.configCache.getConfig("hostname");
                return !TextUtils.isEmpty((CharSequence)hostnameLocal) && hostnameLocal.equals(hostname);
            }
        };
    }

    public OkHttpClient.Builder build() {
        SSLContext sslContext = null;
        try {
            sslContext = this.getSSLContext();
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            LogUtil.getUtils().w((Object)e.getMessage());
        }
        if (sslContext == null) {
            return null;
        }
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder.connectTimeout(30000L, TimeUnit.MILLISECONDS).readTimeout(15000L, TimeUnit.MILLISECONDS).writeTimeout(15000L, TimeUnit.MILLISECONDS).sslSocketFactory(sslContext.getSocketFactory()).hostnameVerifier(this.hostnameVerifier);
        return builder;
    }

    @Nullable
    private SSLContext getSSLContext() throws NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException, KeyManagementException, IOException, CertificateException {
        SSLContext sslContext = SSLContext.getInstance("TLS");
        KeyStore keyStore = this.readKeyStore();
        TrustManagerFactory trustManagerFactory = this.getTrustManagerFactory(keyStore);
        KeyManagerFactory keyManagerFactory = this.getKeyManagerFactory(keyStore);
        sslContext.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), new SecureRandom());
        return sslContext;
    }

    @Nullable
    private KeyStore readKeyStore() throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        if (this.configCache != null) {
            String certPath = this.configCache.getConfig("certpath");
            String certPwd = this.configCache.getConfig("certpwd");
            if (!TextUtils.isEmpty((CharSequence)certPath) && !TextUtils.isEmpty((CharSequence)certPwd)) {
                InputStream inputStream = this.context.getAssets().open(certPath);
                keyStore.load(inputStream, certPwd.toCharArray());
            }
        }
        return keyStore;
    }

    private KeyManagerFactory getKeyManagerFactory(@Nullable KeyStore keyStore) throws NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException {
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        String certPwd = this.configCache.getConfig("certpwd");
        if (!TextUtils.isEmpty((CharSequence)certPwd)) {
            keyManagerFactory.init(keyStore, certPwd.toCharArray());
        }
        return keyManagerFactory;
    }

    @NonNull
    private TrustManagerFactory getTrustManagerFactory(@Nullable KeyStore keyStore) throws NoSuchAlgorithmException, KeyStoreException {
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(keyStore);
        return trustManagerFactory;
    }
}

