/*
 * Decompiled with CFR 0.152.
 */
package com.rabbit.blade.data.net;

import android.support.annotation.NonNull;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava.RxJavaCallAdapterFactory;
import retrofit2.converter.gson.GsonConverterFactory;

public class ServiceGenerator {
    public String API_BASE_URL;
    private Retrofit.Builder retrofitBuilder;
    private final OkHttpClient.Builder okHttpBuilder;

    public ServiceGenerator(@NonNull OkHttpClient.Builder builder, @NonNull String baseUrl) {
        this.okHttpBuilder = builder;
        this.API_BASE_URL = baseUrl;
    }

    public void redirectService(@NonNull String baseUrl) {
        this.retrofitBuilder = null;
        this.API_BASE_URL = baseUrl;
    }

    public synchronized <S> S createService(Class<S> serviceClass, String baseUrl) {
        if (this.retrofitBuilder == null) {
            OkHttpClient client = this.okHttpBuilder.build();
            this.retrofitBuilder = new Retrofit.Builder().baseUrl(HttpUrl.parse((String)baseUrl)).client(client).addCallAdapterFactory(this.callAdapterFactory()).addConverterFactory(this.converterFactory());
        } else {
            this.retrofitBuilder.baseUrl(baseUrl);
        }
        Retrofit retrofit = this.retrofitBuilder.build();
        return (S)retrofit.create(serviceClass);
    }

    public synchronized <S> S createService(Class<S> serviceClass) {
        return this.createService(serviceClass, this.API_BASE_URL);
    }

    public CallAdapter.Factory callAdapterFactory() {
        return RxJavaCallAdapterFactory.create();
    }

    public Converter.Factory converterFactory() {
        return GsonConverterFactory.create();
    }
}

