/*
 * Decompiled with CFR 0.152.
 */
package com.rabbit.blade.data.persistent;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.rabbit.blade.comm.annotation.qua.AroundQua;
import com.rabbit.blade.comm.util.LogUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.inject.Inject;

public class PropertyReader {
    private final Context context;
    private Properties properties;

    @Inject
    public PropertyReader(@NonNull @AroundQua(value="qua_application") Context context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(@NonNull String fileName) throws IOException {
        if (TextUtils.isEmpty((CharSequence)fileName)) {
            return;
        }
        InputStream is = null;
        try {
            is = this.context.getAssets().open(fileName);
            this.properties = new Properties();
            this.properties.load(is);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    LogUtil.getUtils().w((Object)e.getMessage());
                }
            }
        }
    }

    public String get(@NonNull String name) {
        if (this.properties != null && !TextUtils.isEmpty((CharSequence)name)) {
            return this.properties.getProperty(name);
        }
        return null;
    }

    public String get(@NonNull String name, @Nullable String defaultValue) {
        if (this.properties != null && !TextUtils.isEmpty((CharSequence)name)) {
            return this.properties.getProperty(name, defaultValue);
        }
        return null;
    }

    public Map<String, String> getAll() {
        Set<String> keys;
        if (this.properties != null && (keys = this.properties.stringPropertyNames()) != null && !keys.isEmpty()) {
            HashMap<String, String> kv = new HashMap<String, String>();
            for (String key : keys) {
                String value = this.properties.getProperty(key);
                kv.put(key, value);
            }
            return kv;
        }
        return null;
    }
}

