/*
 * Decompiled with CFR 0.152.
 */
package com.rabbit.blade.data.remedy;

import android.support.annotation.Nullable;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.rabbit.blade.data.persistent.PreferencesEditor;
import com.rabbit.blade.data.remedy.RemedyCache;
import javax.inject.Inject;

public class RemedyCacheImpl
implements RemedyCache {
    private final PreferencesEditor util;
    private final Gson gson;

    @Inject
    public RemedyCacheImpl(PreferencesEditor util, Gson gson) {
        this.util = util;
        this.gson = gson;
    }

    @Override
    public <T> boolean cache(String _id, T t) {
        if (t instanceof Integer) {
            return this.util.setIntValue(_id, (Integer)t);
        }
        if (t instanceof Boolean) {
            return this.util.setBooleanValue(_id, (Boolean)t);
        }
        if (t instanceof Float) {
            return this.util.setFloatValue(_id, ((Float)t).floatValue());
        }
        if (t instanceof Long) {
            return this.util.setLongValue(_id, (Long)t);
        }
        if (t instanceof String) {
            return this.util.setStringValue(_id, (String)t);
        }
        return this.util.setStringValue(_id, this.gson.toJson(t));
    }

    @Override
    public boolean simpleCache(String _id) {
        String DEFAULT_VALUE = "1";
        return this.util.setStringValue(_id, DEFAULT_VALUE);
    }

    @Override
    public boolean readSimpleCache(String _id) {
        return this.util.containsKey(_id);
    }

    @Override
    @Nullable
    public <T> T readCache(String _id, Class<T> cls) {
        if (cls == Integer.class) {
            return cls.cast(this.util.getIntValue(_id, 0));
        }
        if (cls == Boolean.class) {
            return cls.cast(this.util.getBooleanValue(_id, false));
        }
        if (cls == Float.class) {
            return cls.cast(Float.valueOf(this.util.getFloatValue(_id, 0.0f)));
        }
        if (cls == Long.class) {
            return cls.cast(this.util.getLongValue(_id, 0L));
        }
        if (cls == String.class) {
            return cls.cast(this.util.getStringValue(_id, ""));
        }
        String value = this.util.getStringValue(_id, "");
        try {
            return (T)this.gson.fromJson(value, cls);
        }
        catch (JsonSyntaxException e) {
            return null;
        }
    }

    @Override
    public void removeCache(String _id) {
        this.util.removeKey(_id);
    }
}

