package com.rabbit.blade.data.cache;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import java.util.Map;

/**
 * <b>Description : 配置信息获取接口</b>
 * <p>Created by <a href="mailto:fanjiandong@outlook.com">fanjiandong</a> on 2017/3/15 17:07.</p>
 */

public interface ConfigCache {

    /**
     * 获取所有的配置信息
     *
     * @return 配置信息集合
     */
    Map<String, String> getAllConfig();

    /**
     * 获取一个配置的值
     *
     * @param name key
     * @return value
     */
    String getConfig(@NonNull String name);

    /**
     * 获取一个配置的值
     *
     * @param name         key
     * @param defaultValue 默认值
     * @return value
     */
    String getConfig(@NonNull String name, @Nullable String defaultValue);
}
