package com.rabbit.blade.data.net;

import android.support.annotation.NonNull;

import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava.RxJavaCallAdapterFactory;
import retrofit2.converter.gson.GsonConverterFactory;

/**
 * <b>Description : 创建REST请求适配的类</b>
 * <p>Created by <a href="mailto:fanjiandong@outlook.com">fanjiandong</a> on 2017/3/15 18:25.</p>
 */


public class ServiceGenerator {

    public String API_BASE_URL;

    private Retrofit.Builder retrofitBuilder;

    private final OkHttpClient.Builder okHttpBuilder;

    public ServiceGenerator(@NonNull OkHttpClient.Builder builder, @NonNull String baseUrl) {
        this.okHttpBuilder = builder;
        this.API_BASE_URL = baseUrl;
    }

    public void redirectService(@NonNull String baseUrl) {
        this.retrofitBuilder = null;
        this.API_BASE_URL = baseUrl;
    }

    public synchronized <S> S createService(Class<S> serviceClass, String baseUrl) {

        if (this.retrofitBuilder == null) {
            OkHttpClient client = this.okHttpBuilder.build();
            this.retrofitBuilder = new Retrofit.Builder()
                    .baseUrl(HttpUrl.parse(baseUrl))
                    .client(client)
                    .addCallAdapterFactory(callAdapterFactory())
                    .addConverterFactory(converterFactory());
        } else {
            this.retrofitBuilder.baseUrl(baseUrl);
        }

        Retrofit retrofit = retrofitBuilder.build();
        return retrofit.create(serviceClass);
    }

    public synchronized <S> S createService(Class<S> serviceClass) {
        return createService(serviceClass, API_BASE_URL);
    }

    public CallAdapter.Factory callAdapterFactory() {
        return RxJavaCallAdapterFactory.create();
    }

    public Converter.Factory converterFactory() {
        return GsonConverterFactory.create();
    }
}
