package com.rabbit.blade.data.remedy;

import android.support.annotation.Nullable;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.rabbit.blade.data.persistent.PreferencesEditor;

import javax.inject.Inject;

/**
 * <b>Description : 补救业务实现类</b>
 * <p>Created by <a href="mailto:fanjiandong@outlook.com">fanjiandong</a> on 2017/3/15 18:17.</p>
 */

public class RemedyCacheImpl implements RemedyCache {

    private final PreferencesEditor util;
    private final Gson gson;

    @Inject
    public RemedyCacheImpl(PreferencesEditor util, Gson gson) {
        this.util = util;
        this.gson = gson;
    }

    @Override
    public <T> boolean cache(String _id, T t) {

        if (t instanceof Integer) {
            return util.setIntValue(_id, ((Integer) t));
        }

        if (t instanceof Boolean) {
            return util.setBooleanValue(_id, ((Boolean) t));
        }

        if (t instanceof Float) {
            return util.setFloatValue(_id, ((Float) t));
        }

        if (t instanceof Long) {
            return util.setLongValue(_id, ((Long) t));
        }

        if (t instanceof String) {
            return util.setStringValue(_id, ((String) t));
        }

        return util.setStringValue(_id, this.gson.toJson(t));
    }

    @Override
    public boolean simpleCache(String _id) {
        String DEFAULT_VALUE = "1";
        return util.setStringValue(_id, DEFAULT_VALUE);
    }

    @Override
    public boolean readSimpleCache(String _id) {
        return util.containsKey(_id);
    }

    @SuppressWarnings("unchecked")
    @Override
    @Nullable
    public <T> T readCache(String _id, Class<T> cls) {
        if (cls == Integer.class) {
            return cls.cast(util.getIntValue(_id, 0));
        }

        if (cls == Boolean.class) {
            return cls.cast(util.getBooleanValue(_id, false));
        }

        if (cls == Float.class) {
            return cls.cast(util.getFloatValue(_id, 0f));
        }

        if (cls == Long.class) {
            return cls.cast(util.getLongValue(_id, 0L));
        }

        if (cls == String.class) {
            return cls.cast(util.getStringValue(_id, ""));
        }

        String value = util.getStringValue(_id, "");

        try {
            return gson.fromJson(value, cls);
        } catch (JsonSyntaxException e) {
            return null;
        }
    }

    @Override
    public void removeCache(String _id) {
        util.removeKey(_id);
    }
}
