package com.rabbit.blade.domain.operator;

import android.support.annotation.Nullable;

/**
 * <b>Description : 参数校验结果定义</b>
 * <p>Created by <a href="mailto:fanjiandong@outlook.com">fanjiandong</a> on 2016/12/27 20:13.</p>
 */

public class VerifyResult<E extends RuntimeException> {
    private boolean isVerify = false;

    @Nullable
    private E exception;

    public VerifyResult() {
        this(false);
    }

    public VerifyResult(boolean isVerify) {
        this(isVerify, null);
    }

    public VerifyResult(@Nullable E exception) {
        this(false, exception);
    }

    public VerifyResult(boolean isVerify, @Nullable E exception) {
        super();
        this.isVerify = isVerify;
        this.exception = exception;
    }

    public boolean isVerify() {
        return isVerify;
    }

    @Nullable
    public E getException() {
        return exception;
    }

    public void setVerify(boolean verify) {
        this.isVerify = verify;
    }

    public void setException(@Nullable E exception) {
        this.exception = exception;
    }
}
