package com.rabbit.blade.domain.usecase;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import java.util.HashMap;
import java.util.Map;

/**
 * <b>Description : 业务参数类 </b>
 * <p>Created by <a href="mailto:fanjiandong@outlook.com">fanjiandong</a> on 2017/1/15 21:45.</p>
 */

public class DomainParam {

    /**
     * The constant NAME_PARAM.
     */
    public static final String NAME_PARAM = "param";
    /**
     * The constant NAME_PARAM1.
     */
    public static final String NAME_PARAM1 = "param1";
    /**
     * The constant NAME_PARAM2.
     */
    public static final String NAME_PARAM2 = "param2";
    /**
     * The constant NAME_PARAM3.
     */
    public static final String NAME_PARAM3 = "param3";
    /**
     * The constant NAME_PARAM4.
     */
    public static final String NAME_PARAM4 = "param4";

    private final Map<String, Object> params;

    public DomainParam() {
        this.params = new HashMap<>();
    }

    public DomainParam param(@NonNull String name, boolean paramValue) {
        this.params.put(name, paramValue);
        return this;
    }

    public DomainParam param(@NonNull String name, byte paramValue) {
        this.params.put(name, paramValue);
        return this;
    }

    public DomainParam param(@NonNull String name, char paramValue) {
        this.params.put(name, paramValue);
        return this;
    }

    public DomainParam param(@NonNull String name, short paramValue) {
        this.params.put(name, paramValue);
        return this;
    }

    public DomainParam param(@NonNull String name, int paramValue) {
        this.params.put(name, paramValue);
        return this;
    }

    public DomainParam param(@NonNull String name, long paramValue) {
        this.params.put(name, paramValue);
        return this;
    }

    public DomainParam param(@NonNull String name, float paramValue) {
        this.params.put(name, paramValue);
        return this;
    }

    public DomainParam param(@NonNull String name, double paramValue) {
        this.params.put(name, paramValue);
        return this;
    }

    public DomainParam param(@NonNull String name, @Nullable String paramValue) {
        this.params.put(name, paramValue);
        return this;
    }

    public DomainParam param(@NonNull String name, @Nullable CharSequence paramValue) {
        this.params.put(name, paramValue);
        return this;
    }

    public <T> DomainParam param(@NonNull String name, @Nullable T paramValue) {
        this.params.put(name, paramValue);
        return this;
    }


    public DomainParam param(@NonNull String name, @Nullable boolean[] paramValue) {
        this.params.put(name, paramValue);
        return this;
    }

    public DomainParam param(@NonNull String name, @Nullable byte[] paramValue) {
        this.params.put(name, paramValue);
        return this;
    }

    public DomainParam param(@NonNull String name, @Nullable char[] paramValue) {
        this.params.put(name, paramValue);
        return this;
    }

    public DomainParam param(@NonNull String name, @Nullable short[] paramValue) {
        this.params.put(name, paramValue);
        return this;
    }

    public DomainParam param(@NonNull String name, @Nullable int[] paramValue) {
        this.params.put(name, paramValue);
        return this;
    }

    public DomainParam param(@NonNull String name, @Nullable long[] paramValue) {
        this.params.put(name, paramValue);
        return this;
    }

    public DomainParam param(@NonNull String name, @Nullable float[] paramValue) {
        this.params.put(name, paramValue);
        return this;
    }

    public DomainParam param(@NonNull String name, @Nullable double[] paramValue) {
        this.params.put(name, paramValue);
        return this;
    }

    public DomainParam param(@NonNull String name, @Nullable String[] paramValue) {
        this.params.put(name, paramValue);
        return this;
    }

    public DomainParam param(@NonNull String name, @Nullable CharSequence[] paramValue) {
        this.params.put(name, paramValue);
        return this;
    }

    public boolean getBooleanParam(@NonNull String name, boolean defaultValue) {
        Object o = this.params.get(name);
        return o != null ? ((boolean) o) : defaultValue;
    }

    public byte getByteParam(@NonNull String name, byte defaultValue) {
        Object o = this.params.get(name);
        return o != null ? ((byte) o) : defaultValue;
    }

    public char getCharParam(@NonNull String name, char defaultValue) {
        Object o = this.params.get(name);
        return o != null ? ((char) o) : defaultValue;
    }

    public short getShortParam(@NonNull String name, short defaultValue) {
        Object o = this.params.get(name);
        return o != null ? ((short) o) : defaultValue;
    }

    public int getIntegerParam(@NonNull String name, int defaultValue) {
        Object o = this.params.get(name);
        return o != null ? ((int) o) : defaultValue;
    }

    public long getLongParam(@NonNull String name, long defaultValue) {
        Object o = this.params.get(name);
        return o != null ? ((long) o) : defaultValue;
    }

    public float getFloatParam(@NonNull String name, float defaultValue) {
        Object o = this.params.get(name);
        return o != null ? ((float) o) : defaultValue;
    }

    public double getDoubleParam(@NonNull String name, double defaultValue) {
        Object o = this.params.get(name);
        return o != null ? ((double) o) : defaultValue;
    }

    @Nullable
    public String getStringParam(@NonNull String name, @NonNull String defaultValue) {
        Object o = this.params.get(name);
        return o != null ? ((String) o) : defaultValue;
    }

    @Nullable
    public CharSequence getCharSequenceParam(@NonNull String name) {
        return ((CharSequence) this.params.get(name));
    }

    @SuppressWarnings("unchecked")
    @Nullable
    public <T> T getParam(@NonNull String name) {
        return ((T) this.params.get(name));
    }

    @Nullable
    public boolean[] getBooleanArrayParam(@NonNull String name) {
        return ((boolean[]) this.params.get(name));
    }

    @Nullable
    public byte[] getByteArrayParam(@NonNull String name) {
        return ((byte[]) this.params.get(name));
    }

    @Nullable
    public char[] getCharArrayParam(@NonNull String name) {
        return ((char[]) this.params.get(name));
    }

    @Nullable
    public short[] getShortArrayParam(@NonNull String name) {
        return ((short[]) this.params.get(name));
    }

    @Nullable
    public int[] getIntegerArrayParam(@NonNull String name) {
        return ((int[]) this.params.get(name));
    }

    @Nullable
    public long[] getLongArrayParam(@NonNull String name) {
        return ((long[]) this.params.get(name));
    }

    @Nullable
    public float[] getFloatArrayParam(@NonNull String name) {
        return ((float[]) this.params.get(name));
    }

    @Nullable
    public double[] getDoubleArrayParam(@NonNull String name) {
        return ((double[]) this.params.get(name));
    }

    @Nullable
    public String[] getStringArrayParam(@NonNull String name) {
        return ((String[]) this.params.get(name));
    }

    @Nullable
    public CharSequence[] getCharSequenceArrayParam(@NonNull String name) {
        return ((CharSequence[]) this.params.get(name));
    }
}
