/*
 * Decompiled with CFR 0.152.
 */
package com.rabbit.blade.domain.usecase;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.rabbit.blade.domain.event.AgentMessage;
import com.rabbit.blade.domain.event.DomainEventProvider;
import com.rabbit.blade.domain.event.MessageEvent;
import com.rabbit.blade.domain.excutor.PostExecutionThread;
import com.rabbit.blade.domain.excutor.ThreadExecutor;
import com.rabbit.blade.domain.usecase.DomainParam;
import com.rabbit.blade.domain.usecase.Interactor;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import rx.Observable;
import rx.Subscriber;
import rx.Subscription;
import rx.functions.Action0;
import rx.functions.Action1;
import rx.functions.Action2;
import rx.functions.Func1;
import rx.observables.ConnectableObservable;
import rx.schedulers.Schedulers;
import rx.subjects.PublishSubject;

public abstract class UseCase<Result>
implements Interactor<Result> {
    @NonNull
    private final ThreadExecutor executor;
    @NonNull
    private final PostExecutionThread mainThread;
    @Nullable
    private PublishSubject<AgentMessage<?>> agentMessagePublishSubject;
    @Nullable
    private Action1<? super Result> onNextAction1;
    @Nullable
    private Action1<Throwable> onErrorAction1;
    @Nullable
    private Action0 onCompletedAction;
    @Nullable
    private Action0 subscribeAction;
    @Nullable
    private Action0 unsubscribeAction;
    @Nullable
    private Action0 onTerminateAction;
    @Nullable
    private Action0 afterTerminateAction;
    @Nullable
    private Action0 onStartAction;
    @Nullable
    private Interactor<?> preInteractor;
    @Nullable
    private Action2<Object, Interactor<Result>> preposeAction;
    @Nullable
    private DomainParam domainParam;
    private Observable<Result> source;
    private ConnectableObservable<Result> connSource;
    private Set<Subscription> msgSubscriptions;
    private Set<Subscription> useCaseSubscriptions;
    private boolean isCanceled = false;
    private boolean isRegistedAgentMessage = false;
    private long eventCategory = Long.MAX_VALUE;

    public UseCase(@NonNull ThreadExecutor threadExecutor, @NonNull PostExecutionThread postExecutionThread) {
        this.executor = threadExecutor;
        this.mainThread = postExecutionThread;
    }

    public abstract Observable<Result> buildUseCaseObservable();

    @Override
    @Nullable
    public final Subscription execute(@NonNull Subscriber<? super Result> useCaseSubscriber, boolean isConnectable) {
        return this.executeWith(useCaseSubscriber, null, isConnectable);
    }

    @Override
    @Nullable
    public final Subscription execute(@NonNull Subscriber<? super Result> useCaseSubscriber) {
        return this.execute(useCaseSubscriber, false);
    }

    @Override
    @Nullable
    public final Subscription execute(@NonNull Action1<? super Result> action1, boolean isConnectable) {
        return this.executeWith(null, action1, isConnectable);
    }

    @Override
    public final Subscription execute(@NonNull Action1<? super Result> action1) {
        return this.execute(action1, false);
    }

    @Override
    @Nullable
    public final Subscription connect() {
        if (this.connSource != null && !this.isCanceled) {
            if (this.onStartAction != null) {
                this.onStartAction.call();
            }
            Subscription subscription = this.connSource.connect();
            return this.pushUseCaseSubscription(subscription);
        }
        return null;
    }

    @Override
    public final <I extends Interactor<Result>> I subscribeMessage(@Nullable Action1<AgentMessage<?>> agentMessageAction1, boolean isSerial) {
        this.subscribeMessageWith(agentMessageAction1, isSerial);
        return (I)this;
    }

    @Override
    @Nullable
    public final Subscription subscribeMessageWith(@Nullable Action1<AgentMessage<?>> agentMessageAction1, boolean isSerial) {
        if (agentMessageAction1 == null || this.isCanceled) {
            return null;
        }
        if (!this.isRegistedAgentMessage) {
            this.isRegistedAgentMessage = true;
            DomainEventProvider.instance().regist(this);
        }
        if (this.agentMessagePublishSubject == null) {
            this.agentMessagePublishSubject = PublishSubject.create();
        }
        Subscription subscription = isSerial ? this.agentMessagePublishSubject.subscribe(agentMessageAction1) : this.agentMessagePublishSubject.observeOn(this.mainThread.getScheduler()).subscribe(agentMessageAction1);
        return this.pushMsgSubscription(subscription);
    }

    @Override
    public final <I extends Interactor<Result>> I cancel() {
        this.unSubscribeMessage();
        if (!this.isCanceled) {
            if (this.useCaseSubscriptions != null && !this.useCaseSubscriptions.isEmpty()) {
                for (Subscription subscription : this.useCaseSubscriptions) {
                    if (subscription == null || subscription.isUnsubscribed()) continue;
                    subscription.unsubscribe();
                }
            }
            this.isCanceled = true;
        }
        return (I)this;
    }

    @Override
    public final boolean isCanceled() {
        return this.isCanceled;
    }

    @Override
    public final <I extends Interactor<Result>> I unSubscribeMessage() {
        if (this.isRegistedAgentMessage) {
            if (this.msgSubscriptions != null && !this.msgSubscriptions.isEmpty()) {
                for (Subscription subscription : this.msgSubscriptions) {
                    if (subscription == null || subscription.isUnsubscribed()) continue;
                    subscription.unsubscribe();
                }
            }
            DomainEventProvider.instance().unRegist(this);
            this.isRegistedAgentMessage = false;
        }
        return (I)this;
    }

    public void dispatchMessageEvent(@Nullable MessageEvent<?> messageEvent) {
        if (messageEvent == null || this.isCanceled || !this.isRegistedAgentMessage) {
            return;
        }
        Long category = (Long)messageEvent.getCategory();
        if (category == null) {
            category = Long.MAX_VALUE;
        }
        if (category != this.eventCategory) {
            return;
        }
        AgentMessage agentMessage = (AgentMessage)messageEvent.getMaterialContent();
        if (this.agentMessagePublishSubject != null) {
            this.agentMessagePublishSubject.onNext((Object)agentMessage);
        }
    }

    @Override
    public final <I extends Interactor<Result>> I doOnNext(Action1<? super Result> onNextAction1) {
        this.onNextAction1 = onNextAction1;
        return (I)this;
    }

    @Override
    public final <I extends Interactor<Result>> I doOnError(Action1<Throwable> onErrorAction1) {
        this.onErrorAction1 = onErrorAction1;
        return (I)this;
    }

    @Override
    public final <I extends Interactor<Result>> I doOnCompleted(Action0 onCompletedAction) {
        this.onCompletedAction = onCompletedAction;
        return (I)this;
    }

    @Override
    public final <I extends Interactor<Result>> I doOnSubscribe(Action0 subscribeAction) {
        this.subscribeAction = subscribeAction;
        return (I)this;
    }

    @Override
    public final <I extends Interactor<Result>> I doOnUnsubscribe(Action0 unsubscribeAction) {
        this.unsubscribeAction = unsubscribeAction;
        return (I)this;
    }

    @Override
    public final <I extends Interactor<Result>> I doOnTerminate(Action0 onTerminateAction) {
        this.onTerminateAction = onTerminateAction;
        return (I)this;
    }

    @Override
    public final <I extends Interactor<Result>> I doAfterTerminate(Action0 afterTerminateAction) {
        this.afterTerminateAction = afterTerminateAction;
        return (I)this;
    }

    @Override
    public final <I extends Interactor<Result>> I doOnStart(Action0 onStartAction) {
        this.onStartAction = onStartAction;
        return (I)this;
    }

    @Override
    public final <I extends Interactor<Result>, I1 extends Interactor<?>> I preposeInteractor(@Nullable I1 preInteractor, @Nullable Action2<Object, I> preposeAction) {
        this.preInteractor = preInteractor;
        this.preposeAction = preposeAction;
        return (I)this;
    }

    @Override
    public final <Result1, I1 extends Interactor<Result1>> I1 composeInteractor(@NonNull I1 composeInteractor, @NonNull Action2<Result, I1> composeAction) {
        composeInteractor.preposeInteractor((UseCase)this, composeAction);
        return (I1)composeInteractor;
    }

    public final void setEventCategory(long eventCategory) {
        this.eventCategory = eventCategory;
    }

    @Override
    public final <I extends Interactor<Result>> I params(@Nullable DomainParam domainParam) {
        this.domainParam = domainParam;
        return (I)this;
    }

    @Override
    public final <I extends Interactor<Result>, Param> I params(@Nullable Param param) {
        if (this.domainParam == null) {
            this.domainParam = new DomainParam();
        }
        this.domainParam.param("param", param);
        return (I)this;
    }

    @Override
    public final <I extends Interactor<Result>, Param, Param1> I params(@Nullable Param param, @Nullable Param1 param1) {
        this.params(param);
        if (this.domainParam != null) {
            this.domainParam.param("param1", param1);
        }
        return (I)this;
    }

    @Override
    public final <I extends Interactor<Result>, Param, Param1, Param2> I params(@Nullable Param param, @Nullable Param1 param1, @Nullable Param2 param2) {
        this.params(param, param1);
        if (this.domainParam != null) {
            this.domainParam.param("param2", param2);
        }
        return (I)this;
    }

    @Override
    public final <I extends Interactor<Result>, Param, Param1, Param2, Param3> I params(@Nullable Param param, @Nullable Param1 param1, @Nullable Param2 param2, @Nullable Param3 param3) {
        this.params(param, param1, param2);
        if (this.domainParam != null) {
            this.domainParam.param("param3", param3);
        }
        return (I)this;
    }

    @Override
    public final <I extends Interactor<Result>, Param, Param1, Param2, Param3, Param4> I params(@Nullable Param param, @Nullable Param1 param1, @Nullable Param2 param2, @Nullable Param3 param3, @Nullable Param4 param4) {
        this.params(param, param1, param2, param3);
        if (this.domainParam != null) {
            this.domainParam.param("param4", param4);
        }
        return (I)this;
    }

    @Nullable
    public final DomainParam getDomainParam() {
        return this.domainParam;
    }

    @Override
    @Nullable
    public final <Param> Param getParam() {
        if (this.domainParam != null) {
            return (Param)this.domainParam.getParam("param");
        }
        return null;
    }

    @Override
    @Nullable
    public final <Param1> Param1 getParam1() {
        if (this.domainParam != null) {
            return (Param1)this.domainParam.getParam("param1");
        }
        return null;
    }

    @Override
    @Nullable
    public final <Param2> Param2 getParam2() {
        if (this.domainParam != null) {
            return (Param2)this.domainParam.getParam("param2");
        }
        return null;
    }

    @Override
    @Nullable
    public final <Param3> Param3 getParam3() {
        if (this.domainParam != null) {
            return (Param3)this.domainParam.getParam("param3");
        }
        return null;
    }

    @Override
    @Nullable
    public final <Param4> Param4 getParam4() {
        if (this.domainParam != null) {
            return (Param4)this.domainParam.getParam("param4");
        }
        return null;
    }

    private Subscription executeWith(@Nullable Subscriber<? super Result> useCaseSubscriber, @Nullable Action1<? super Result> action1, boolean isConnectable) {
        if (useCaseSubscriber == null && action1 == null || this.isCanceled) {
            return null;
        }
        this.source = this.buildObservable().subscribeOn(Schedulers.from((Executor)this.executor)).observeOn(this.mainThread.getScheduler());
        Subscription subscription = null;
        if (isConnectable) {
            if (this.source != null) {
                this.connSource = this.source.publish();
            }
            if (this.connSource != null) {
                subscription = useCaseSubscriber != null ? this.connSource.subscribe(useCaseSubscriber) : this.connSource.subscribe(action1);
            }
        } else {
            if (this.onStartAction != null) {
                this.onStartAction.call();
            }
            subscription = useCaseSubscriber != null ? this.source.subscribe(useCaseSubscriber) : this.source.subscribe(action1);
        }
        return this.pushUseCaseSubscription(subscription);
    }

    private Observable<Result> buildObservable() {
        Observable<?> preObservable = this.buildPreObservable();
        if (preObservable != null) {
            return preObservable.flatMap(new Func1<Object, Observable<Result>>(){

                public Observable<Result> call(Object o) {
                    if (UseCase.this.preposeAction != null) {
                        UseCase.this.preposeAction.call(o, (Object)UseCase.this);
                    }
                    return UseCase.this.faceObservable();
                }
            });
        }
        return this.faceObservable();
    }

    @Nullable
    private Observable<?> buildPreObservable() {
        Observable<Result> preObservable = null;
        if (this.preInteractor != null) {
            preObservable = ((UseCase)this.preInteractor).buildObservable();
        }
        return preObservable;
    }

    private Observable<Result> faceObservable() {
        Observable buo = this.buildUseCaseObservable();
        if (this.onNextAction1 != null) {
            buo = buo.doOnNext(this.onNextAction1);
        }
        if (this.onErrorAction1 != null) {
            buo = buo.doOnError(this.onErrorAction1);
        }
        if (this.onCompletedAction != null) {
            buo = buo.doOnCompleted(this.onCompletedAction);
        }
        if (this.subscribeAction != null) {
            buo = buo.doOnSubscribe(this.subscribeAction);
        }
        if (this.unsubscribeAction != null) {
            buo = buo.doOnUnsubscribe(this.unsubscribeAction);
        }
        if (this.onTerminateAction != null) {
            buo = buo.doOnTerminate(this.onTerminateAction);
        }
        if (this.afterTerminateAction != null) {
            buo = buo.doAfterTerminate(this.afterTerminateAction);
        }
        return buo;
    }

    private Subscription pushUseCaseSubscription(Subscription subscription) {
        return this.pushSubscription(subscription, this.useCaseSubscriptions);
    }

    private Subscription pushMsgSubscription(Subscription subscription) {
        return this.pushSubscription(subscription, this.msgSubscriptions);
    }

    private Subscription pushSubscription(Subscription subscription, Set<Subscription> collections) {
        if (subscription == null) {
            return null;
        }
        if (collections == null) {
            collections = new HashSet<Subscription>(1);
        }
        collections.add(subscription);
        return subscription;
    }
}

